import { loadView, accessToken, alertMessageError, replacePath } from '../../components/functions.js';

import {
    createTable,
    dataTable,
    removeItemTable,
} from "../../components/tables.js";

import { renderTr } from './renderMedia.js';

const system = "websites";
const module = "media";
const pathUrl = "modules/websites/";
const tableId = "mediaTable";

export const mediaIndex = (vars = []) => {
    //console.log('mediaIndex', vars);
    loadView(_PATH_WEB_NUCLEO + "modules/websites/views/media.html?v" + _VS).then((responseView) => {
        //console.log('loadView', responseView);
        getData({
            task: 'getMediaList',
            return: 'returnArray', // returnId, returnState, returnArray, returnMessage, returnObject
        }).then((response) => {
            console.log('getData getMediaList', response);
            let str = responseView;
            str = str.replace(/{{_MODULE}}/g, module);
            str = str.replace(/{{_SYSTEM}}/g, system);
            str = str.replace(/{{_PATHURL}}/g, pathUrl);
            str = str.replace(/{{_FN}}/g, "formNewMedia");
            str = replacePath(str);
            $(".bodyModule[module='" + module + "']").html(str);
            if (response != null && response.Error == 0) {
                const tableId = "tableEvents";
                const data = response.data;
                let strTable = "";
                let tbody = "";
                //console.log(data);

                for (let i = 0; i < data.length; i++) {
                    const elem = data[i];
                    elem["table"] = tableId;
                    elem["module"] = module;
                    elem["system"] = system;
                    tbody += renderTr(elem);
                }

                strTable = createTable({
                    id: tableId,
                    thead: ":check,id:colId,Nombre,Estado:colState,Acciones:colActions",
                    body: tbody,
                });

                $(".bodyModule[module='" + module + "'] >.tbody").html(
                    strTable
                );

                dataTable({
                    elem: "#" + tableId,
                    orderCol: 1,
                });
            } else if (response.data == 0) {
                $(".bodyModule[module='" + module + "'] >.tbody").html(
                    renderNoDataTable()
                );
            } else {
                alertMessageError({ message: response.message })
            }
        }).catch(console.warn());

    }).catch(console.warn());
}

export const getData = async (vars = []) => {
    //console.log('getData', vars);
    const url = _PATH_WEB_NUCLEO + "modules/websites/controllers/apis/v1/media.php";
    let data = JSON.stringify({
        accessToken: accessToken(),
        vars: JSON.stringify(vars)
    });
    try {
        let res = await axios({
            async: true,
            method: "post",
            responseType: "json",
            url: url,
            headers: {},
            data: data
        })
        //console.log(res.data);
        return res.data;
    } catch (error) {
        console.log("Error: getDataPlaces", error);
    }
}
