"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.verifySession = verifySession;

var _dashboard = require("./dashboard.js");

var _index = require("../../components/functions.js");

var _lang = require("../../components/lang.js");

document.addEventListener("DOMContentLoaded", function () {});
verifySession();
$("body").on("click", "#btnSingIn", function () {
  var email = $("#inputEmail").val();
  var password = $("#inputPassword").val();
  autentication({
    email: email,
    password: password
  });
});

function verifySession() {
  //console.log("verifySession")
  var access_token = localStorage.getItem("access_token"); //console.log("access_token: " + access_token)

  if (access_token != null && access_token != undefined && access_token != "") {
    //console.log("tiene session");
    (0, _dashboard.loadDashboard)();
  } else {
    //console.log("loginRoot")
    loadLoginRoot().then(function (data) {
      //console.log(data);
      $("#root").html(data);
      (0, _lang.translate)();
    });
  }
}

function loadLoginRoot() {
  var url, contentAwait, str;
  return regeneratorRuntime.async(function loadLoginRoot$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          url = _PATH_WEB_NUCLEO + _PATH_DASHBOARD + "views/login.html";
          _context.prev = 1;
          _context.next = 4;
          return regeneratorRuntime.awrap(fetch(url));

        case 4:
          contentAwait = _context.sent;
          _context.next = 7;
          return regeneratorRuntime.awrap(contentAwait.text());

        case 7:
          str = _context.sent;
          //console.log("loadLoginRoot:" + str);
          str = (0, _index.replacePath)(str);
          str = str.replace("{{_PATH_BRAND}}", _PATH_WEB + _PATH_DASHBOARD_BRAND);
          str = str.replace("{{_VS}}", _VS); // $("#root").html(str);

          return _context.abrupt("return", str);

        case 14:
          _context.prev = 14;
          _context.t0 = _context["catch"](1);
          console.log("loadLoginRoot Error:" + _context.t0);

        case 17:
        case "end":
          return _context.stop();
      }
    }
  }, null, null, [[1, 14]]);
}

function autentication(vars) {
  //console.log(_PATH_WEB_NUCLEO + 'controllers/apis/v1/login/auth.php')
  var url = _PATH_WEB_NUCLEO + "modules/dashboard/controllers/apis/v1/auth.php";
  var token = localStorage.getItem("bearerToken"); // let h = new Headers();
  // h.append('Authentication', `Bearer ${token}`);

  var dataForm = new FormData();
  dataForm.append("page", _PATH_PAGE);
  dataForm.append("authentication", "Bearer ".concat(token));
  dataForm.append("grant_type", "token");
  dataForm.append("email", vars.email);
  dataForm.append("password", vars.password);
  dataForm.append("client_id", localStorage.getItem("clientId"));
  dataForm.append("client_secret", localStorage.getItem("clientSecret"));
  var req = new Request(url, {
    method: "POST",
    mode: "cors",
    body: dataForm
  });
  fetch(req).then(function (resp) {
    return resp.json();
  }).then(function (data) {
    // console.log("autentication:" + data);
    if (data["Error"] == "0") {
      // console.log("autentication: e" + data);
      localStorage.setItem("access_token", data.access_token);
      localStorage.setItem("token_type", data.token_type);
      localStorage.setItem("refresh_token", data.refresh_token);
      localStorage.setItem("idEntitie", data.idEntitie);
      $(".pubLogin .pub-inner").addClass("animated fadeOut");
      setTimeout(function () {
        (0, _dashboard.loadDashboard)();
      }, 1000);
    } else {
      (0, _index.alertMessageError)(data["message"]); //console.log("Error" + data);

      console.log(data); //console.log(data["descripcion"]);
    }
  })["catch"](function (err) {
    console.error("Error Request " + err.message);
  });
}