"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadDashboard = loadDashboard;
exports.returnBoxUpFileCircle = returnBoxUpFileCircle;
exports.returnBoxUpFile = returnBoxUpFile;
exports.boxRol = boxRol;

var _nav = require("../../components/nav.js");

var _index = require("../../components/functions.js");

var _login = require("./login.js");

var porc = 0;
var img1 = new Image();
img1.src = _PATH_WEB_NUCLEO + "modules/assets/img/bend.svg";
document.addEventListener("DOMContentLoaded", function () {
  //console.log("dashboard")
  (0, _index.getScript)(_PATH_WEB_NUCLEO + "modules/dashboard/components/login.js", "head");
});

function loadDashboard() {
  (0, _nav.loadMenu)().then(function (menusJson) {
    //console.log(menusJson);
    if (menusJson != 0) {
      //console.log(menusJson.message)
      if (menusJson.message != "Error") {
        (0, _nav.structureMenus)(menusJson); // of loadMenu
      } else {
        //console.log('clear');
        (0, _index.alertMessageError)(menusJson.message);
        localStorage.clear();
        localStorage.setItem("bearerToken", _BEARER_TOKEN);
        localStorage.setItem("clientId", _CLIENT_ID);
        localStorage.setItem("clientSecret", _CLIENT_SECRET);
        (0, _login.verifySession)();
      }
    } else {
      console.log("Error Menu Return.");
    }
  });
} //files


function returnBoxUpFileCircle(varId) {
  //console.log("rb:" + varId)
  $(".boxIcon[for='" + varId + "']").html('<i class="icon icon-photo-camera"></i><span>Cargar Foto max. 500x500px</span>');
}

function returnBoxUpFile(varId) {
  //console.log("rb:" + varId)
  $(".boxIcon[for='" + varId + "']").parent().css("padding", "30px 10px");
  var text = $("#" + varId + "[returnaction='returnBoxUpFile']").attr("textreturnaction");
  $(".boxIcon[for='" + varId + "']").html('<i class="icon icon-upfile"></i><span>' + text + "</span>");
}

function boxRol(rol) {
  return '<div class="boxRol">' + rol + "</div>";
}