"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.brokersCustomersIndex = brokersCustomersIndex;

var _index = require("../../components/functions.js");

var _nav = require("../../components/nav.js");

var _renderBrokers = require("./renderBrokers.js");

var _module = "brokersCustomers";
var system = "brokers";
var pathurl = "modules/brokers/";

function brokersCustomersIndex(vars) {
  (0, _index.loadView)(_PATH_WEB_NUCLEO + "modules/brokers/views/brokersCustomers.html?" + _VS).then(function (str) {
    loadCustomersCompanys().then(function (response) {
      str = str.replace(/{{_TITLE_MODULE}}/g, "Clientes");
      str = str.replace(/{{_ICON_MODULE}}/g, "icon-users");
      str = str.replace(/{{_MODULE}}/g, _module);
      str = str.replace(/{{_SYSTEM}}/g, system);
      str = (0, _index.replacePath)(str);

      if (response.Error == 0) {
        var tableId = "tableCustomersCompanys";
        var data = response.items;
        var _str = htmlView;
        var strTable = "";
        var tbody = ""; //console.log(data)

        for (var i = 0; i < data.length; i++) {
          var elem = data[i];
          elem["table"] = tableId;
          elem["module"] = _module;
          elem["system"] = system;
          tbody += (0, _renderBrokers.renderTr)(elem);
        }

        strTable = createTable({
          id: tableId,
          thead: ":check,id:colId,Nombre,Estado:colState,Acciones:colActions",
          body: tbody
        });
        $(".bodyModule[module='" + _module + "']").html(_str);
        $(".bodyModule[module='" + _module + "'] .tabContent[item=1]").html(strTable);
        dataTable({
          elem: "#" + tableId,
          orderCol: 1
        });
        (0, _nav.resizeWorkspace)();
      } else if (response === 0) {
        $(".bodyModule[module='" + _module + "']").html(str);
        $(".bodyModule[module='" + _module + "'] .tabContent[item=1] .tbody").html((0, _renderBrokers.renderEmpty)());
      } else {
        (0, _index.alertPage)({
          text: "Error. por favor contactarse con soporte. " + response.message,
          icon: "icn icon-alert-warning",
          animation_in: "bounceInRight",
          animation_out: "bounceOutRight",
          tipe: "danger",
          time: "3500",
          position: "top-left"
        });
      }
    });
  });
}

function loadCustomersCompanys() {
  var url, dataForm, res;
  return regeneratorRuntime.async(function loadCustomersCompanys$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          url = _PATH_WEB_NUCLEO + "modules/brokers/controllers/apis/v1/customers.php";
          dataForm = new FormData();
          dataForm.append("accessToken", JSON.stringify(_index.accessToken));
          dataForm.append("action", "loadCustomersCompanys");
          _context.prev = 4;
          _context.next = 7;
          return regeneratorRuntime.awrap(axios({
            async: true,
            method: "post",
            responseType: "json",
            url: url,
            headers: {},
            data: dataForm
          }));

        case 7:
          res = _context.sent;
          console.log(res.data);
          return _context.abrupt("return", res.data);

        case 12:
          _context.prev = 12;
          _context.t0 = _context["catch"](4);
          console.log(_context.t0);

        case 15:
        case "end":
          return _context.stop();
      }
    }
  }, null, null, [[4, 12]]);
}

document.addEventListener("DOMContentLoaded", function () {
  /*  $("body").on("click", "module[] .btnAddCustomerCompany", function (e) {
       e.preventDefault()
       e.stopPropagation()
       e.stopImmediatePropagation()
       loadView(
           _PATH_WEB_NUCLEO + "modules/brokers/views/formCompany.html?" + _VS
       ).then((str) => {
           str = str.replace(/{{_MODULE}}/g, module)
           str = str.replace(/{{_SYSTEM}}/g, system)
           str = str.replace(/{{_TITLE_HEAD}}/g, "Agregar Empresa")
           str = str.replace(/{{_FORM_ID}}/g, "formCompany")
           str = replacePath(str)
           $(".bodyModule[module='" + module + "']").prepend(str)
           $("#formCompany").draggable()
           $("#inputName").focus()
       })
   }) */
});