"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCustomersAll = exports.loadFormNewCustomerCompany = exports.customersIndex = void 0;

var _index = require("../../components/functions.js");

var _forms = require("../../components/forms.js");

var _modals = require("../../components/modals.js");

var _tables = require("../../components/tables.js");

var _renderTables = require("../../components/renders/renderTables.js");

var _renderModals = require("../../components/renders/renderModals.js");

/* renderColTitle,
	renderColState,
	renderColActionsBase, */
var pathurl = "modules/accounts/";
var _module = "customers";
var system = "accounts";
var tableId = "table-contents";

var customersIndex = function customersIndex() {
  console.log("customersIndex");
  (0, _index.loadView)(_PATH_WEB_NUCLEO + pathurl + "views/customers.html?" + _VS).then(function (htmlView) {
    //console.log(htmlView, module, system);
    getCustomersAll().then(function (response) {
      console.log("getCustomersAll", response);
      (0, _index.stopLoadingBar)();
      $(".innerForm").remove();
      $(".bodyModule[module='" + _module + "']").html((0, _index.replaceEssentials)({
        str: htmlView,
        module: _module,
        system: system,
        pathurl: pathurl,
        name: (0, _index.dataModule)(_module, "name"),
        fn: "formNewCustomerCompany",
        btnNameAction: "Nuevo Cliente Empresa",
        icon: (0, _index.dataModule)(_module, "icon"),
        color: (0, _index.dataModule)(_module, "color")
      }));
      /* if (response.Error == 0 && response.items != 0) {
      		let rows = "";
      	for (let i in response.items) {
      		let item = response.items[i];
      		//console.log("item", item);
      		rows += renderRowsTable({
      			id: item.id,
      			content: renderColCheck({
      					id: item.id,
      				}) +
      				renderColId({
      					id: item.id,
      				}) +
      				renderColTitle({
      					id: item.id,
      					title: item.nameFull,
      				}) +
      				
                                     renderCol({
                                         id: item.id,
                                         cls: '',
                                         attr: '',
      					data: item.gender,
                                     }) +
                                     renderCol({
                                         id: item.id,
                                         cls: '',
                                         attr: '',
      					data: item.type,
                                     }) +
                                     renderCol({
                                         id: item.id,
                                         cls: '',
                                         attr: '',
      					data: item.timezone,
                                     }) +
                                     renderCol({
                                         id: item.id,
                                         cls: '',
                                         attr: '',
      					data: item.recordDate,
                                     }) +
      				renderColState({
      					id: item.id,
      					state: item.state,
      					module,
      					system,
      				}) +
                                     
      				renderColActions({
      					id: item.id,
      					name: item.title,
      					type: "btnEdit,btnDelete",
      					fnType: "formEditContent,deleteModuleItem",
      					module,
      					system,
      				}),
      		});
      	}
      	
      	mountTable({
      		id: tableId,
      		columns: [
      			...colCheck,
      			...colId,
                                 {
                                     label: "Nombre Completo",
                                     cls: "colNameFull",
                                 },
      			
                                 {
      				label: "Genero",
      				cls: "",
                                 },
                                 {
      				label: "Tipo/r",
      				cls: "",
                                 },
                                 {
      				label: "Timezone",
      				cls: "",
                                 },
                                 {
      				label: "Fecha Registro",
      				cls: "colDareRegister",
                                 },
      			...colState,
      			...colActionsBase,
      		],
      		rows,
      		module,
      		system,
      		container: ".bodyModule[module='" + module + "'] .tbody",
      	}); 
      	} else if (response === 0 || response.items == 0) {
      	$(".bodyModule[module='" + module + "']  .tbody").html(renderEmpty())
      } else {
      	alertPage({
      		text: "Error. por favor contactarse con soporte. " +
      			response.message,
      		icon: "icn icon-alert-warning",
      		animation_in: "bounceInRight",
      		animation_out: "bounceOutRight",
      		tipe: "danger",
      		time: "3500",
      		position: "top-left",
      	})
      } */
    })["catch"](console.warn());
  });
};

exports.customersIndex = customersIndex;

var loadFormNewCustomerCompany = function loadFormNewCustomerCompany() {
  var vars = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  console.log('loadFormNewCustomerCompany', vars);
}; //asycs  


exports.loadFormNewCustomerCompany = loadFormNewCustomerCompany;

var getCustomersAll = function getCustomersAll() {
  var vars,
      url,
      data,
      res,
      _args = arguments;
  return regeneratorRuntime.async(function getCustomersAll$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          vars = _args.length > 0 && _args[0] !== undefined ? _args[0] : [];
          //console.log('getCustomersAll', vars);
          url = _PATH_WEB_NUCLEO + "modules/accounts/controllers/apis/v1/customers.php";
          data = JSON.stringify({
            accessToken: (0, _index.accessToken)(),
            action: "getCustomersAll",
            vars: vars
          });
          _context.prev = 3;
          _context.next = 6;
          return regeneratorRuntime.awrap(axios({
            async: true,
            method: "post",
            responseType: "json",
            url: url,
            headers: {},
            data: data
          }));

        case 6:
          res = _context.sent;
          return _context.abrupt("return", res.data);

        case 10:
          _context.prev = 10;
          _context.t0 = _context["catch"](3);
          console.log("Error: getCustomersAll");
          console.log(_context.t0);

        case 14:
        case "end":
          return _context.stop();
      }
    }
  }, null, null, [[3, 10]]);
};

exports.getCustomersAll = getCustomersAll;
document.addEventListener('click', function (e) {
  e.preventDefault();
  e.stopPropagation();
  e.stopImmediatePropagation();

  if (e.target.matches(".btnAddCustomerCompany")) {
    loadFormNewCustomerCompany();
  }
});