<?PHP
header('Content-Type: text/html; charset=utf-8_spanish_ci');
class DATA
{

    var $fmt;

    function __construct($fmt)
    {
        $this->fmt = $fmt;
    }

    public function dateFormat($timezone = "America/La_Paz", $format = "Y-m-d H:i:s", $setlocale = "es_ES")
    {
        setlocale(LC_TIME, $setlocale);
        date_default_timezone_set($timezone);
        return date($format);
    }

    function formatUri($string, $separator = '-')
    {
        $accents_regex = '~&([a-z]{1,2})(?:acute|cedil|circ|Grave|lig|orn|ring|slash|th|tilde|uml);~i';
        $special_cases = array('&' => 'and', "'" => '');
        $string = mb_strtolower(trim($string), 'UTF-8');
        $string = str_replace(array_keys($special_cases), array_values($special_cases), $string);
        $string = preg_replace($accents_regex, '$1', htmlentities($string, ENT_QUOTES, 'UTF-8'));
        $string = preg_replace("/[^a-z0-9]/u", "$separator", $string);
        $string = preg_replace("/[$separator]+/u", "$separator", $string);
        return $string;
    }

    public function convertFn(string $str = null)
    {
        //return $str;
        $array = explode("_", $str);
        $cont = count($array);
        $string = '';
        for ($i = 0; $i < $cont; $i++) {
            $string .= ucfirst($array[$i]);
        }
        if ($cont == 0) {
            $string = $str;
        }

        return $string;
    }

    public function dbDate($date = null, $activeHours = 1)
    {
        $arrayDate = explode(' ', $date);
        $hours = $arrayDate[1] ? $arrayDate[1] : '00:00:00';
        $arrayDate[0] = str_replace('/', '-', $arrayDate[0]);
        $arrayDates = explode('-', $arrayDate[0]);
        $day = $arrayDates[0];
        $month = $arrayDates[1];
        $year = $arrayDates[2];

        if (strlen($day) == 1) {
            $day = '0' . $day;
        }
        if (strlen($month) == 1) {
            $month = '0' . $month;
        }

        if ($activeHours == 1) {
            return $year . '-' . $month . '-' . $day . ' ' . $hours;
        } else {
            return $year . '-' . $month . '-' . $day;
        }
    }

    public function limitText(array $var = null)
    {
        $text = $var['text'];
        $type = $var['type'];
        $num = $var['num'];
        $subfix = $var['subfix'] ? $var['subfix'] : '...';

        if ($type == 'chars') {
            if (strlen($text) > $num) {
                $str = substr($text, 0, $num) . $subfix;
            } else {
                $str = $text;
            }
        }
        return $str;
    }

    public function timeCompact(array $vars = null)
    {
        //return $vars;
        $dateInit =  $vars['dateInit'];
        $dateEnd =  $vars['dateEnd'];
        $mode =  $vars['mode'];

        $ini = explode(" ", $dateInit);
        $fIni = $ini[0];
        $hIni = $ini[1];
        $fIni = explode("-", $fIni);
        $hIni = explode(":", $hIni);

        $hora = $hIni[0] . "" . $hIni[1];

        $date1 = date_create($dateInit);
        $date2 = date_create($dateEnd);
        $diff = date_diff($date1, $date2);

        $dias =  $diff->format("%d%");
        $anos =  $diff->format("%y%");
        $meses =  $diff->format("%m%");
        $horas =  $diff->format("%h%");
        $min =  $diff->format("%i%");
        $seg =  $diff->format("%s%");
        //echo $elapsed;

        //return $dias.":".$anos.":".$meses.":".$horas.":".$min .":".$seg;

        if ($anos != 0) {
            return $this->fecha_hora_compacta($dateInit);
        }
        if ($meses != 0) {
            return $this->fecha_hora_compacta($dateInit);
        }

        if ($dias != 0) {
            return $this->fecha_hora_compacta($dateInit);
        }

        if ($horas != 0) {
            return $horas . "h";
        }

        if ($min != 0) {
            return $min . "m";
        }

        if ($seg != 0) {
            return $seg . "s";
        } else {
            return "1s";
        }
    }

    function fecha_hora_compacta($fecha, $formato = "d,m,a,h,mi,s")
    {
        $fechaHora = explode(" ", $fecha);
        $fechas = explode("-", $fechaHora[0]);
        $tiempo = explode(":", $fechaHora[1]);
        $ano = $fechas[0];
        $mes = (string)(int)$fechas[1];
        $dia = $fechas[2];
        $hora = $tiempo[0];
        $min = $tiempo[1];
        $seg = substr($tiempo[2], 0, 2);
        // $F="";


        $day = array(' ', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie');
        $month = array(' ', 'Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic');
        $fx = explode(",", $formato);
        $nfx = count($fx);

        $F .= "<div class='block-date'>";

        $d = " <span class='dia'>" . $dia . " </span>";
        $m = " <span class='mes'>" . $month[$mes] . " </span>";
        $a = " <span class='ano'>" . $ano . " </span>";
        $h = " <span class='hora'>" . $hora . "</span>";
        $mi = " <span class='min'>" . $min . "</span>";
        $s = " <span class='seg'>" . $seg . "</span>";

        for ($j = 0; $j < $nfx; $j++) {
            if ($fx[$j] == "d") {
                $F .= $d;
            }
            if ($fx[$j] == "m") {
                $F .= $m;
            }
            if ($fx[$j] == "a") {
                $F .= $a;
            }
            if ($fx[$j] == "h") {
                $F .= $h;
            }
            if ($fx[$j] == "mi") {
                $F .= $mi;
            }
            if ($fx[$j] == "s") {
                $F .= $s;
            }
        }

        $F .= "</div>";

        return $F;
    }

    public function createCode($vars = null)
	{
		$num = $this->fmt->emptyReturn(intval($vars["num"]), 6);
		$prefix = $this->fmt->emptyReturn($vars["prefix"], "");
		$mode = $this->fmt->emptyReturn($vars["mode"], "");

		switch ($mode) {
			case 'number':
				$pattern = "1234567890";
				break;
            case 'integer':
				$pattern = "123456789";
				break;

			default:
				$pattern = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%&*-";
				break;
		}

		//return  $pattern.":".$num;
		//$pattern = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%&*-";
		// $pattern = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		$key = '';
		//return strlen($pattern);

		$key = substr(str_shuffle($pattern), 0, $num);

		return $prefix . $key;
	}
}