<?php
header('Content-Type: text/html; charset=utf-8');
class AUTH
{

	var $fmt;

	function __construct($fmt)
	{
		$this->fmt = $fmt;
	}

	public function index()
	{

		$rootIndex =  $this->getArrayUrl();

		$key = "userId";

		//var_dump($rootIndex); exit(0);
		//echo $rootIndex[1];

		switch ($rootIndex[0]) {
			case 'activation':
				if ($rootIndex[1] == "user") {
					$tokenAuth = $rootIndex[2];
					require_once(_PATH_HOST . "ion/activation.php");
					exit(0);
				}
				//require_once(_PATH_NUCLEO . "modules/login/login.local.php");
				break;
			case 'login':
				if ($this->fmt->sessions->getVar("keySession") == false) {
					require_once(_PATH_NUCLEO . "modules/login/login.local.php");
				} else {
					$path = $this->fmt->setUrlNucleo($this->fmt->users->idRolRedirectionUrl($this->fmt->sessions->getVar("userRol")));
					echo '<script type="text/javascript" >document.location.href="' . $path . '";</script>';
					exit(0);
				}
				break;

			case 'dashboard':
				require_once(_PATH_NUCLEO . "modules/dashboard/index.php");
				break;
			case 'logout':
				require_once(_PATH_NUCLEO . "modules/login/logout.local.php");
				break;

			case 'forgot':
				$this->validateSession(_PATH_NUCLEO . "modules/login/forgot.local.php", $key);
				break;

			case 'apis':
				require_once(_PATH_HOST. "apis/".$rootIndex[1]."/".$rootIndex[2].".php");
				break;

			default:
				$this->indexRoot();
				break;
		}

		//Worksheet = planilla / hoja de trabajo
	}

	public function indexReactive(string $mode = null)
	{
		//return $var;
		define("_ROOT_GET",  "");
		define("_PATH_DASHBOARD", "modules/dashboard/");
		
		$rootIndex =  $this->getArrayUrl();
		//var_dump($rootIndex);
		if (empty($rootIndex[0])) {
			$cat = 1;
			$worksheet = 1;
			//echo "here emply";
			$body = $this->fmt->worksheets->loadBody($cat, $worksheet);
			echo $this->fmt->worksheets->htmlReactive($body);
		} else {
			//echo "here no emply";
			if (strrpos(end($rootIndex), "?m=react")) {
				$root = end($rootIndex);
				$root = str_replace("?m=react", "", $root);
				if ($this->matchCategory($root)) {
					$cat = $this->matchCategory($root);
					$worksheet  = 1;
					echo $this->fmt->worksheets->loadBody($cat, $worksheet);
				} else {
					echo "error-404,";
				}
			} else {
				//echo "no react" . end($rootIndex);
				if ($this->matchCategory(end($rootIndex))) {

					$cat = $this->matchCategory(end($rootIndex));
					$worksheet  = 1;
					//echo "cat:" . $cat;
					$body = $this->fmt->worksheets->loadBody($cat, $worksheet);
					echo $this->fmt->worksheets->htmlReactive($body);
				} else {
					echo "error-404,";
				}
			}
		}
	}

	public function getArrayUrl($url = "")
	{
		if (empty($url)) {
			$link = $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"];
			//return $_SERVER["HTTP_HOST"];
			//return $_SERVER["REQUEST_URI"];
			//return _TYPE_URI.$link;
			//return _PATH_WEB;
			$link = str_replace(_PATH_WEB, "", _TYPE_URI . $link);
			$escaped_link = htmlspecialchars($link, ENT_QUOTES, 'UTF-8');
			return  explode("/", $escaped_link);
		} else {
			$url = str_replace(_PATH_WEB, "", $url);
			$escaped_link = htmlspecialchars($url, ENT_QUOTES, 'UTF-8');
			return  explode("/", $escaped_link);
		}
	}

	public function indexRoot()
	{
		//echo "indexRoot";
		if (_MULTI_SITE == "on") {
			//multisite

		} else {
			$rootIndex =  $this->getArrayUrl();
			//var_dump($rootIndex); exit(0);
			//echo "end:" . end($rootIndex);
			//echo _TYPE_URI.$_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]; exit(0);
			if ($this->matchCategory(end($rootIndex))) {
				//echo $this->matchCategory(end($rootIndex));
				$cat = $this->matchCategory(end($rootIndex));
				$this->enterSite($cat, 1);
			} else {
				//echo "EnterSite";
				if (empty(end($rootIndex))) {
					//echo "caso ultima categoria econtrada;
					$this->enterSite(1,1);
				} else {
					$str = end($rootIndex);
					
					if (strpos($str, "?") !== false) {
						$rootIndex = $this->getArrayUrl();
						$rootAux = explode("?",$rootIndex[0]);
						//var_dump($rootAux);
						//var_dump(trim($rootAux[1]));
						define("_ROOT_GET",  trim($rootAux[1]));

						$str = $rootAux[0];

						if ($this->matchCategory($str)) {
							$cat = $this->matchCategory($str);
							$worksheet = 1;
							//echo "mach category";
							$this->enterSite($cat, $worksheet);
						} else {
							echo "error-404,";
						}
					} else {
						echo "error-404,";
						$this->enterSite(1, 1);
					}
					//require( _PATH_HOST . str_replace(_PATH_PAGE."", "",$_SERVER["REQUEST_URI"]));
					//require( _PATH_HOST . str_replace("/"._PATH_PAGE, "",$_SERVER["REQUEST_URI"]));
				}
			}
		}
	}

	public function matchCategory($str)
	{
		/*  */
		$sql = "SELECT cat_id FROM categorys WHERE  cat_pathurl='" . $str . "' or cat_path='" . $str . "'  and cat_state='1' ";
		$rs = $this->fmt->querys->consult($sql);
		$num = $this->fmt->querys->num($rs);
		if ($num > 0) {
			$row = $this->fmt->querys->row($rs);
			return $row["cat_id"];
		} else {
			return 0;
		}
		$this->fmt->querys->leave();
	}

	public function enterSite($cat, $worksheet)
	{
		//echo "$cat, $worksheet";
		// if ($this->fmt->sesion->get_variable("usu_id")){
		// 	define('_ESTADOPUBLICACION','true');
		//   }else{
		// 	define('_ESTADOPUBLICACION','false');
		//   }
		echo $this->fmt->worksheets->loadHeader($cat, $worksheet);
		echo $this->fmt->worksheets->loadBody($cat, $worksheet);
		echo $this->fmt->worksheets->loadFooter($cat, $worksheet);
	}

	public function validateSession($root, $key)
	{
		if (!empty(_PATH_LOGOUT)) {
			$pathLogout = _PATH_LOGOUT;
		} else {
			$pathLogout = _PATH_WEB;
		}

		if ($this->fmt->sessions->getVar("keySession") == false) {
			echo '<script type="text/javascript" >document.location.href="' . $pathLogout . '";</script>';
			exit(0);
		}
		require_once($root);
	}

	public function user($vars = null)
	{
		$jsonVars = json_decode($vars);
		$inputEmail = $jsonVars->inputEmail;
		$inputPassword = $jsonVars->inputPassword;
		$error = [];
		if (!$this->fmt->validations->email($inputEmail)) {
			array_push($error, 'email');
		}
		if (empty($inputPassword)) {
			array_push($error, 'password');
		}
		if (!$error) {
			$userData = $this->fmt->users->userData($inputEmail, $inputPassword);
			if ($userData != 0 ) {
				$userData["signIn"] += true;

				$this->fmt->sessions->setSession(array(
					'userId' => $userData["user_id"],
					'userName' => $userData["user_name"],
					'userEmail' => $inputEmail,
					'userRol' => $userData["user_rol"]
				));
				return json_encode($userData);
			} else {
				return json_encode(array('return' => 'error', 'error' => 'no-exist-acount'));
			}
		} else {
			return json_encode(array('return' => 'error', 'error' => json_encode($error)));
		}
		//$this->ftm->user->rolUser()
	}

	public function getInput($index, $value = '')
	{
		if (isset($_POST[$index]) && !empty($_POST[$index])) {
			$value = $_POST[$index];
		} else if (isset($_GET[$index]) && !empty($_GET[$index])) {
			$value = $_GET[$index];
		}

		return $value;
	}

	public function bearerToken()
	{
		return $this->fmt->options->getValue("bearer_token");
	}

	public function getApi()
	{
		return [
			'client_id' => $this->fmt->options->getValue("client_id"),
			'client_secret' => $this->fmt->options->getValue("client_secret"),
		];
	}

	public function validationToken($vars = null)
	{
		$access_token = $vars["access_token"];
		$refresh_token = $vars["refresh_token"];
		$return = [];

		$var = base64_decode($access_token);
		$arrayUserDates = explode(".", $var);
		$return["userId"] = $arrayUserDates[1];
		$return["rolId"] =  $arrayUserDates[2];

		$sql = "SELECT DISTINCT user_tk_user_id FROM users_tokens WHERE user_tk_type='access_token' AND user_tk_user_id='" . $return["userId"] . "' AND user_tk_token='" . $access_token . "'";
		$rs = $this->fmt->querys->consult($sql);
		$num = $this->fmt->querys->num($rs);
		if ($num == 0) {
			return  0;
			exit(0);
		}
		$this->fmt->querys->leave();

		$sql = "SELECT DISTINCT user_tk_user_id FROM users_tokens WHERE user_tk_type='refresh_token' AND user_tk_user_id='" . $return["userId"] . "' AND user_tk_token='" . $refresh_token . "'";
		$rs = $this->fmt->querys->consult($sql);
		$num = $this->fmt->querys->num($rs);
		if ($num == 0) {
			return  0;
			exit(0);
		}
		$this->fmt->querys->leave();

		return $return;
	}

	public function createCode($vars = null)
	{
		$num = $this->fmt->emptyReturn(intval($vars["num"]), 6);
		$prefix = $this->fmt->emptyReturn($vars["prefix"], "");
		$mode = $this->fmt->emptyReturn($vars["mode"], "");

		switch ($mode) {
			case 'number':
				$pattern = "1234567890";
				break;

			default:
				$pattern = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%&*-";
				break;
		}

		//return  $pattern.":".$num;
		//$pattern = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%&*-";
		// $pattern = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		$key = '';
		//return strlen($pattern);

/* 		for ($i = 0; $i < $num; $i++) {

			$key .= $pattern{rand(1, strlen($pattern))};
		} */
		$key = substr(str_shuffle($pattern), 0, $num);

		return $prefix . $key;
	}

	public function validateBearerToken($token = null)
	{
		if ($this->bearerToken() == $token) {
			return 1;
		} else {
			return 0;
		}
	}

	public function validateTokenSession(array $var = null)
	{
		//return $var;
		$bearerToken = $var["bearerToken"];
		$clientId = $var["clientId"];
		$clientSecret = $var["clientSecret"];

		$bearerTokenSystem = $this->fmt->options->getValue("bearer_token");
		$clientIdSystem = $this->fmt->options->getValue("client_id");
		$clientSecretSystem = $this->fmt->options->getValue("client_secret");

		if ($bearerToken == $bearerTokenSystem && $clientId == $clientIdSystem && $clientSecret == $clientSecretSystem) {
			return 1;
		} else {
			return 0;
		}
	}

	public function getActionState($state = null)
	{
		if ($state == 1) {
			$rtr["Error"] = 0;
			$rtr["status"] = "success";
			$rtr["state"] = $state;
			echo json_encode($rtr);
			exit(0);
		} else {
			$rtr["Error"] = 1;
			$rtr["status"] =  'error';
			$rtr["message"] =  $state;
			echo json_encode($rtr);
			exit(0);
		}
	}

	public function getActionReturnId($state = null)
	{
		if ($state != 0 && is_int($state)) {
			$rtr["Error"] = 0;
			$rtr["status"] = "success";
			$rtr["data"] = $state;
			echo json_encode($rtr);
			exit(0);
		} else if ($state === 0) {
			$rtr["Error"] = 1;
			$rtr["status"] = "error";
			$rtr["data"] = $state;
			$rtr["message"] = $state;
			echo json_encode($rtr);
			exit(0);
		} else {
			$rtr["Error"] = 1;
			$rtr["status"] = "error";
			$rtr["message"] =  $state;
			echo json_encode($rtr);
			exit(0);
		}
	}

	public function getActionReturnArray($state = null)
	{
		if ($state === 0 ) {
			$rtr["Error"] = 0;
			$rtr["status"] = "success";
			$rtr["data"] = $state;
			$rtr["message"] = 'data 0';
			echo json_encode($rtr);
			exit(0);
		}
		if (count($state) > 0) {
			$rtr["Error"] = 0;
			$rtr["status"] = "success";
			//$rtr["state"] = $state;
			$rtr["data"] = $state;
			echo json_encode($rtr);
			exit(0);
		}
		 
		$rtr["Error"] = 1;
		$rtr["status"] = "error";
		$rtr["data"] = "";
		$rtr["message"] =  $state;
		echo json_encode($rtr);
		exit(0);
	}

	public function getActionReturnMessage($state = null){
		//echo json_encode($state); exit(0);
		if (($state != "0") && ($state != "error")) {
			$rtr["Error"] = 0;
			$rtr["status"] = "success";
			$rtr["message"] = $state;
			$rtr["data"] = $state;
			echo json_encode($rtr);
			exit(0);
		}
		if (!(is_string($state)) || ($state == "error") || ($state === 0)) {
			$rtr["Error"] = 1;
			$rtr["status"] = "error";
			$rtr["message"] =  $state;
			echo json_encode($rtr);
			exit(0);
		}
		
	}

	public function getReturnObject($state = []){
		echo json_encode($state); exit(0);
	}

	function urlExists( $url = NULL ) {

		//var_dump(@fopen($url,"r")); exit(0);
 
       	$curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
			CURLOPT_HEADER => false,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_FOLLOWLOCATION => false,
			CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => false,
			CURLOPT_NOBODY => false,
        ));

        $response = curl_exec($curl);

		if (curl_errno($curl)) {
        	$err     = curl_errno($curl);
        	$errmsg  = curl_error($curl);
        	$header  = curl_getinfo( $curl , CURLINFO_HTTP_CODE );
		}

		curl_close($curl);
		
		$elm = explode(",",$response);
	
		//var_dump($elm); exit(0);
		
		if( $elm[0] != "error-404") {
			return 1;
		} else {
			return 0;
		}
	}


	function getFileUrl( $url = NULL , $vars = NULL) {
 
        if( empty( $url ) ){
            return false;
        }
    
        $curl = curl_init();

		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $vars);
 
	
		$response   = curl_exec($curl);

		$err     = curl_errno();
        $errmsg  = curl_error();
        $header  = curl_getinfo();
    
        // Obtener el código de respuesta
        $httpcode = curl_getinfo( $curl, CURLINFO_HTTP_CODE );
        //cerrar conexión
        curl_close( $ch );


        $header['errno']   = $err;
        $header['errmsg']  = $errmsg;
        $header['content'] = $response;
    
        // Aceptar solo respuesta 200 (Ok), 301 (redirección permanente) o 302 (redirección temporal)
        $accepted_response = array( 200, 301, 302 );
        if( in_array( $httpcode, $accepted_response ) ) {
            return $header;
        } else {
            return false;
        }
    }

	public function setData($url) { 
		$curl = curl_init(); 
		curl_setopt($curl, CURLOPT_URL, $url); 
		curl_setopt($curl, CURLOPT_FILETIME, true); 
		curl_setopt($curl, CURLOPT_NOBODY, true); 
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); 
		$header["header"] = curl_exec($curl); 
		$header["info"] = curl_getinfo($curl); 
		curl_close($curl); 

		$header['errno']   = $err;
        $header['errmsg']  = $errmsg;
        $header['content'] = $response;

		$accepted_response = array( 200, 301, 302 );
        if( in_array( $httpcode, $accepted_response ) ) {
            return $header;
        } else {
            return false;
        }

	}

}