import {
	empty,
	replacePath,
	replaceEssentials,
	replaceAll,
	loadView,
	stopLoadingBar,
	emptyReturn,
	loadingBtnIcon,
	btnLoadingRemove,
	unDisableId,
	accessToken,
	removeBtnLoading,
	alertMessageError,
	dataModule,
	addHtml,
	capitalize,
    jointActions
} from "../../components/functions.js";

let module = "links";
let system = "websites";

export const linksIndex = (vars =[]) => {
    console.log('linksIndex',vars);
    loadView(_PATH_WEB_NUCLEO + "modules/websites/views/links.html?" + _VS).then((responseView) => {
        //console.log('loadView', responseView);
        let content = responseView;
        getData({
            task: 'getLinksList',
            return: 'returnArray', // returnId, returnState, returnArray, returnMessage, returnObject
        }).then((response) => {
            console.log('getLinksList', response);
            if(response.status=='success'){

                addHtml({
                    selector: `.bodyModule[module='${module}']`, 
                    type: 'insert', 
                    content
                }) //type: html, append, prepend, before, after
        
            }else{
                 alertMessageError({message: response.message})
            }
        }).catch(console.warn());
       

    }).catch(console.warn());
}

export const getData = async (vars = []) => {
   //console.log('getData', vars);
   const url = _PATH_WEB_NUCLEO + "modules/websites/controllers/apis/v1/links.php";
   let data = JSON.stringify({
       accessToken: accessToken(),
       vars: JSON.stringify(vars)
   });
   try {
       let res = await axios({
           async: true,
           method: "post",
           responseType: "json",
           url: url,
           headers: {},
           data: data
        })
       //console.log(res.data);
       jointActions(res.data)
       return res.data
   } catch (error) {
      console.log("Error: getData ", error);
   }
}