import {
    addHtml,
    loadView,
    accessToken
} from "../../components/functions.js"


export const systemsIndex = (vars = []) => {
    loadView(_PATH_WEB_NUCLEO + "modules/users/views/systems.html?" + _VS).then((responseView) => {
        //console.log('loadView', responseView);
        let str = responseView;
        str = str.replace(/{{_COLOR}}/g, $(".btnItemMenu[path='systems']").attr("color"));
        str = str.replace(/{{_ICON}}/g, "icon icon-system");
        str = str.replace(/{{_NAME}}/g, "Systemas");
        addHtml({
            selector: `#contentConfigAdmin`,
            type: 'insert', // insert, append, prepend, replace
            content: str
        })

        getData({
            task: 'getSystems',
            return: 'returnArray', // returnId, returnState, returnArray

        }).then((response) => {
            console.log('getSystems', response);
            if (response.status == 'success') {

            } else {
                alertMessageError({
                    message: response.message
                })
            }
        }).catch(console.warn());
    }).catch(console.warn());
}

export const getData = async (vars = []) => {
    //console.log('getData', vars);
    const url = _PATH_WEB_NUCLEO + "modules/users/controllers/apis/v1/users.php";
    let data = JSON.stringify({
        accessToken: accessToken(),
        vars: JSON.stringify(vars)
    });
    try {
        let res = await axios({
            async: true,
            method: "post",
            responseType: "json",
            url: url,
            headers: {},
            data: data
        })
        //console.log(res.data);
        return res.data
    } catch (error) {
        //console.log("Error: getDataPlaces")
        //console.log(error)
    }
}