<?php
header('Content-Type: text/html; charset=utf-8');
class PAYMENTS
{
    var $fmt;

    function __construct($fmt)
    {
        $this->fmt = $fmt;
    }

    public function getPayEventQR(array $var =  null){
        //return $var;

        require_once(_PATH_NUCLEO . "modules/accounts/models/class/class.customers.php");
        $customers = new CUSTOMERS($this->fmt);


        $eventId = $var['eventId'];
        $statusState = $var['statusState'];

        $sql = "SELECT * FROM mod_payments_tx_tickets WHERE mod_pay_tx_tck_id = '".$eventId."' AND mod_pay_tx_tck_state = '".$statusState."' AND mod_pay_tx_tck_type = 'QR'";
        $rs =$this->fmt->querys->consult($sql,__METHOD__);
        $num=$this->fmt->querys->num($rs);
        if($num>0){
            for($i=0;$i<$num;$i++){
                $row=$this->fmt->querys->row($rs);
                $id = $row["mod_pay_tx_tck_id"];
                $return[$i]["id"] = $id;
                $cpeId = $row["mod_pay_tx_tck_cpe_id"];
                $return[$i]["cpeId"] = $cpeId;
                $return[$i]["dataCpeId"] = $customers->getCustomerPersonId($cpeId);
                $return[$i]["txr"] = $row["mod_pay_tx_tck_txr"];
                // encode json $callback
                $json  =$row["mod_pay_tx_tck_callback"];

                // Decodificar el JSON
                $data = json_decode($json);

                // Verificar si hay errores en el JSON
                if (json_last_error() !== JSON_ERROR_NONE) {
                    // Corregir el JSON
                    $json = preg_replace('/\s*([{}])\s*/', '$1', $json);
                    $data = json_decode($json);
                }

                // Volver a codificar el JSON
                $json = json_encode($data);
                $return[$i]["callback"] = $json;
            }
            return $return;
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs);
        
    }

    public function registerTxTicketEvent(array $var = null)
    {
        require_once(_PATH_NUCLEO . "modules/accounts/models/class/class.customers.php");
        $customers = new CUSTOMERS($this->fmt);


        $userId = $var["user"]["userId"];
        $rolId = $var['user']['rolId'];
        $entitieId = $var['entitieId'];
        $input = $var['vars']['input'];
        $acp = $input['acp'];
        $cpeId = $input['cpeId']    ?? 0;
        $eveId = $input['eveId'] ?? 0;
        $reserveId = $input['reserveId'] ?? 0;
        $pay = $input['pay'] ?? "0.00";
        $coin = $input['coin'] ?? "Bs";
        $rs = $input['rs'] ?? "";
        $nit = $input['nit'] ?? "";
        $type = $input['type'] ?? "";
        $valueType = $input['valueType'] ?? "";
        $state = $input['state'] ?? 0;
        $now = $this->fmt->data->dateFormat();
        $code = $this->fmt->data->createCode(['num' => 6, 'mode' => 'integer']);
        $code = $now . $code;
        $code = hash('sha256', $code);
        $cpe = $customers->getCustomerPersonId($cpeId);
        $var["cpe"] = $cpe;
        $json = json_encode($var);


        if ($cpeId == 0 || $eveId == 0 || $reserveId == 0) {
            $return["Error"]  = 1;
            $return["status"]  = "error";
            $return["message"]  = "No se ha seleccionado un evento ni una reserva.";
            return 0;
        }

        if ($type == "cash" || $type == "transfer" || $type == "card") {
            $state = 3;
        }

        $insert = "mod_pay_tx_tck_acp_id,mod_pay_tx_tck_cpe_id,mod_pay_tx_tck_eve_id,mod_pay_tx_tck_reserve_id,mod_pay_tx_tck_pay,mod_pay_tx_tck_code,mod_pay_tx_tck_coin,mod_pay_tx_tck_rs,mod_pay_tx_tck_nit,mod_pay_tx_tck_type,mod_pay_tx_tck_txr,mod_pay_tx_tck_register_date,mod_pay_tx_tck_user_id,mod_pay_tx_tck_json,mod_pay_tx_tck_state";
        $values = "'" . $acp . "','" . $cpeId . "','" . $eveId . "','" . $reserveId . "','" . $pay . "','" . $code . "','" . $coin . "','" . $rs . "','" . $nit . "','" . $type . "','" . $valueType . "','" . $now . "','" . $userId . "','" . $json . "','" . $state . "'";
        $sql = "insert into mod_payments_tx_tickets (" . $insert . ") values (" . $values . ")";
        $this->fmt->querys->consult($sql, __METHOD__);

        $sql = "select max(mod_pay_tx_tck_id) as id from mod_payments_tx_tickets";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $row = $this->fmt->querys->row($rs);
        $id = $row["id"];

        $return["code"] = $code;
        $return["id"] = $id;
        return $return;
    }

    public function pay_libelula(array $var = null)
    {
        //return $var;

        require_once(_PATH_NUCLEO . "modules/accounts/models/class/class.customers.php");
        $customers = new CUSTOMERS($this->fmt);

        require_once(_PATH_NUCLEO . "modules/tickets/models/class/tickets.class.php");
        $tickets = new TICKETS($this->fmt);

        $cpeId = $var['cpeId'] ?? 0;
        $eventId = $var['eventId'] ?? 0;
        $reserveId = $var['reserveId'] ?? 0;
        $pay = $var['pay'] ?? "0.00";
        $coin = $var['coin'] ?? "Bs";
        $rs = $var['rs'] ?? "";
        $nit = $var['nit'] ?? "";
        $type = $var['type'] ?? "";
        $tk  = $var['tokenTx'] ?? "";
        // decode base 64
        
        $cpe = $customers->getCustomerPersonId($cpeId);
        $token = base64_encode($cpe["id"]."-".$cpe['email']."-".$eventId."-".$reserveId."-".$tk);
        $sussessPay = $token;
        $payToken = $token;
        $event = $tickets->getEventId($eventId);
        $identificador = $var['identificador'];
        $name = $cpe['name'];
        $lastname = $cpe['lastname'];
        $email = $cpe['email'];

        
        $now = $this->fmt->data->dateFormat();
        $now = date("Y-m-d H:i:s", strtotime($now . "+ 15 minutes"));

        //return _PATH_WEB.'apis/v1/pay-success.php?id='.$sussessPay;

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.todotix.com/rest/deuda/registrar',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{
            "appkey": "11bb10ce-68ba-4af1-8eb7-4e6624fed729",
            "email_cliente": "'.$email.'",
            "identificador": "'.$tk.'",
            "callback_url": "'._PATH_WEB.'apis/v1/pay-success.php?id='.$sussessPay.'",
            "url_retorno": "'._PATH_WEB.'ion/pay?id='.$payToken.'",
            "descripcion": "Pago Reserva #'.$reserveId.' - '.$event['name'].' - '.$event['initDate'].'",
            "nombre_cliente": "'.$name.'",
            "apellido_cliente": "'.$lastname.'",
            "nit": "'.$nit.'",
            "razón_social": "'.$rs.'",
            "ci": "'.$ci.'",
            "emite_factura": 0,
            "tipo_factura": 3,
            "fecha_vencimiento": "'.$now.'",
            "lineas_detalle_deuda": [
                {
                    "concepto": "TEST PRODUCTO 1",
                    "cantidad": 1,
                    "costo_unitario": 1,
                    "descuento_unitario": 0
                }
            ],
            "lineas_metadatos": [
                {
                    "nombre": "Promo",
                    "dato": "Liquidación especial de invierno"
                },
                {
                    "nombre": "Vendedor",
                    "dato": "Juan Perez"
                },
                {
                    "nombre": "Tienda",
                    "dato": "Tienda Virtual 001"
                }
            ]
        }',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        $response = json_decode($response,true);

       if (($response["error"] == 0) && ($response["qr_simple_error"] == "")){
            $sqlx = "UPDATE mod_payments_tx_tickets SET 
                        mod_pay_tx_tck_state = '2',
                        mod_pay_tx_tck_txr = '".$response['id_transaccion']."',
                        mod_pay_tx_tck_return = '".json_encode($response)."'
                    WHERE mod_pay_tx_tck_id = '" . $identificador . "' AND mod_pay_tx_tck_code = '".$tk."'";
            $this->fmt->querys->consult($sqlx);
            //$rtn["sql"] =  $sqlx ;
            $rtn["Error"] = 0;
            $rtn["status"] = 'success';
            $rtn["message"] = 'se ha generado el codigo qr y registro de pago';
        } 

        if ($response["qr_simple_error"] != ""){
            $sqlx = "UPDATE mod_payments_tx_tickets SET 
                        mod_pay_tx_tck_return = '".json_encode($response)."'
                    WHERE mod_pay_tx_tck_id = '" . $identificador . "' AND mod_pay_tx_tck_code = '".$tk."'";
            $this->fmt->querys->consult($sqlx);

            $rtn["Error"] = 1;
            $rtn["status"] = 'error';
            $rtn["message"] = $response["qr_simple_error"];            
        }

        $rtn["response"] = $response;
        $rtn["url"] = _PATH_WEB.'apis/v1/pay-success.php?id='.$sussessPay;
        return $rtn;
    }
}
