export const renderMapaCoordenadas = (lugarActual = "") => {
    var html = "";

    html += `
		<div class="form-control form-coordPrincipal">
			<input type="hidden" id="coordenadas" />
			<div id="mapCoor"></div>
		</div>
	`;
    //console.log(lugarActual);
    let dat = lugarArrayDatos(lugarActual);
    console.log("coord:" + dat['lat'] + "," + dat['long']);

    var lat = dat['lat'];
    var long = dat['long'];


    $("#coordPrincipal").html(html);
    $("#coordPrincipal #coordenadas").val(lat + "," + long);

    var mapOptions = {
        zoom: 18,
        center: new google.maps.LatLng(lat, long),
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    var mapCoor = new google.maps.Map(document.getElementById('mapCoor'),
        mapOptions);
    var infoWindow = new google.maps.InfoWindow({
        content: '',
        buttons: {
            close: { visible: false }
        }
    });
    $('<div id="windowInfo"/>').addClass('centerMarker').appendTo(mapCoor.getDiv())
        .click(function () {
            if (formattedAddress) {
                infoWindow.bindTo('position', mapCoor, 'center');
                infoWindow.open(mapCoor);
            }
        });


    var geocoder = new google.maps.Geocoder(); // create a geocoder object
    var formattedAddress = null;
    function updateAddress(lat, long) {

        geocoder.geocode({
            'latLng': new google.maps.LatLng(lat, long)
        }, function (results, status) {
            if (status == google.maps.GeocoderStatus.OK) {           // if geocode success
                formattedAddress = results[0].formatted_address;// if address found, pass to processing function
                //$('#address').html(formattedAddress);
                $('#coordenadas').val(lat + "," + long);
            }
            infoWindow.setContent(formattedAddress);
        });
    }
    updateAddress(lat, long);

    function gEventCallback(e) {
        updateAddress(this.getCenter().lat(), this.getCenter().lng());
    }

    google.maps.event.addListener(mapCoor, 'drag', gEventCallback);
    google.maps.event.addListener(mapCoor, 'dragend', gEventCallback);
    google.maps.event.addListener(mapCoor, 'zoom_changed', gEventCallback);
}

export const lugarArrayDatos = (lugarActual) => {
    var lugarArray = lugarActual.split(",");
    var lat = "";
    var long = "";
    var dat = new Array;

    if (lugarActual != "") {
        lat = lugarArray["0"].replace(/ /g, "");
        long = lugarArray["1"].replace(/ /g, "");
    } else {
        // aqui va input
        lat = "-17.783456";
        long = "-63.180269";
    }

    dat["lat"] = lat;
    dat["long"] = long;

    return dat;
}