<?php
header('Content-Type: text/html; charset=utf-8');
class ACCOUNTS
{

    var $fmt;
    var $pla;
    var $cat;

    function __construct($fmt)
    {
        $this->fmt = $fmt;
    }

    public function dataId($userId = null)
    {
        $sql = "SELECT * FROM mod_accounts_users WHERE mod_acu_id='" . $userId . "' ";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            return  $this->fmt->querys->row($rs);
        } else {
            return 0;
        }
        $this->fmt->query->leave($rs);
    }

    public function dataRol(int $rolId = null)
    {
        
        $sql = "SELECT * FROM mod_accounts_roles WHERE mod_acu_rol_id='" . $rolId . "' ";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            $rtn["id"] = $row["mod_acu_rol_id"];
            $rtn["name"] = $row["mod_acu_rol_name"];
            $rtn["description"] = $row["mod_acu_rol_description"];
            $rtn["parentId"] = $row["mod_acu_rol_parent_id"];
            $rtn["redirectionUrl"] = $row["mod_acu_rol_redirection_url"];
            $rtn["json"] = $row["mod_acu_rol_json"];
            $rtn["state"] = $row["mod_acu_rol_state"];

            return $rtn;
        } else {
            return 0;
        }
        $this->fmt->query->leave($rs);
        
    }

    public function dataAccount($userId = null)
    {
        $sql = "SELECT * FROM mod_accounts_users WHERE mod_acu_id='" . $userId . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            $id = $row["mod_acu_id"];
            $return["id"] = $id;
            $return["name"] = $row["mod_acu_name"];
            $return["lastname"] = $row["mod_acu_fathers_lastname"] . " " . $row["mod_acu_mothers_lastname"];
            $return["email"] = $row["mod_acu_email"];
            $birthdayDate = $row["mod_acu_birthday_date"];
            $return["ageRange"] = $this->ageRange($birthdayDate);
            $return["age"] = $this->age($birthdayDate);
            $return["stateBirthday"] = $this->stateBirthday($birthdayDate);
            $return["gender"] = $row["mod_acu_gender"];
            $return["dial"] = $row["mod_acu_dial"] ? $row["mod_acu_dial"] : $this->fmt->options->getValue("default_dial");
            $return["celular"] = $row["mod_acu_celular"];
            
            return $return;
        } else {
            return 0;
        }
        $this->fmt->query->leave($rs);
    }

    public function dataEnterprise(int $cpeId = null){
        //return $var;
        $sql = "SELECT * FROM mod_customers_enterprises WHERE mod_cen_cpe_id='" . $cpeId . "'";
        $rs =$this->fmt->querys->consult($sql,__METHOD__);
        $num=$this->fmt->querys->num($rs);
        if($num>0){
            $row = $this->fmt->querys->row($rs);
            $id = $row["mod_cen_id"];
            $return["id"] = $id;
            $return["name"] = $row["mod_cen_name"];
            $return["username"] = $row["mod_cen_username"];
            $return["code"] = $row["mod_cen_code"];
            $return["img"] = $this->fmt->files->imgReturn($row["mod_cen_img"]);
            $return["dateRegister"] = $row["mod_cen_register_date"];
            $return["state"] = $row["mod_cen_state"];

            return $return;
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs);
    }

    public function dataClient(int $acuId = null){
        //return $var;
        $sql = "SELECT * FROM mod_customers_persons WHERE mod_cpe_acu_id='" . $acuId . "'";
        $rs =$this->fmt->querys->consult($sql,__METHOD__);
        $num=$this->fmt->querys->num($rs);
        if($num>0){
            $row = $this->fmt->querys->row($rs);
            $id = $row["mod_cpe_id"];
            $return["id"] = $id;
            $return["name"] = $row["mod_cpe_name"];
            $return["lastname"] = $row["mod_cpe_lastname"];
            $return["email"] = $row["mod_cpe_email"];
            $return["code"] = $row["mod_cpe_code"];
            $return["dateRegister"] = $row["mod_cpe_register_date"];
            $return["state"] = $row["mod_cpe_state"];

            return $return;
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs);
    }

    public function stateBirthday( $birthdayDate = null){
        $today = $this->fmt->modules->dateFormat("","m-d");

        $firstDate  =  date('m-d', strtotime($birthdayDate));
        if ($firstDate == $today){
            return 1;
        }else{
            return 0;
        }
    }

    public function ageRange( $birthdayDate = null){
        //return $var;
        $today = $this->fmt->modules->dateFormat();

        $firstDate  = new DateTime($birthdayDate);
        $secondDate = new DateTime($today);
        $dif = $firstDate->diff($secondDate);
        $years = $dif->y; 
        
        if ($years < '17'){ 
            return '14-17'; 
        }elseif ($years < '24'){
            return '18-24';
        }elseif ($years < '34'){
            return '25-34';
        }elseif ($years < '44'){
            return '35-44';
        }elseif ($years < '54'){
            return '45-54';
        }elseif ($years < '64'){
            return '55-64';
        } 

        return '65+';
                 
    }

    public function age( $birthdayDate = null){
        //return $var;
        $today = $this->fmt->modules->dateFormat();

        $firstDate  = new DateTime($birthdayDate);
        $secondDate = new DateTime($today);
        $dif = $firstDate->diff($secondDate);
        return  $dif->y; 
    }

    public function loadAccountsUsers($array = null)
    {
        $array;
        $userId = $array["user"]["userId"];
        $rolId = $array["user"]["rolId"];
        $entitieId = $array["entitieId"];
        $vars = $array["vars"];
        $orderBy = $this->fmt->emptyReturn($array["vars"]["orderBy"], "mod_acu_record_date DESC");
        $limit = $this->fmt->emptyReturn($array["vars"]["limit"], "");

        if ($orderBy == "recordDate ASC") {
            $orderBy = "mod_acu_record_date ASC";
        }
        if ($orderBy == "recordDate DESC") {
            $orderBy = "mod_acu_record_date DESC";
        }

        if ($limit != "") {
            $limit = "LIMIT " . $limit;
        }

        $sql = "SELECT DISTINCT * FROM mod_accounts_users WHERE mod_acu_ent_id = '" . $entitieId . "' ORDER BY " . $orderBy  . $limit;
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            for ($i = 0; $i < $num; $i++) {
                $row = $this->fmt->querys->row($rs);
                $id = $row["mod_acu_id"];
                $name = $row["mod_acu_name"];
                $lastname = $row["mod_acu_fathers_lastname"] . " " . $this->fmt->emptyReturn($row["mod_acu_mothers_lastname"], "");
                $return[$i]["id"] = $id;
                $return[$i]["nameFull"] = $name." ". $lastname;
                $return[$i]["name"] =  $name;
                $return[$i]["lastname"] =  $lastname;
                $return[$i]["fathersLastname"] =  $row["mod_acu_fathers_lastname"];
                $return[$i]["mothersLastname"] =  $this->fmt->emptyReturn($row["mod_acu_mothers_lastname"], "");   
                $return[$i]["ageRange"] = $row["mod_acu_age_range"];
                $return[$i]["email"] = $row["mod_acu_email"];
                $return[$i]["birthdayDate"] = $row["mod_acu_birthday_date"];
                //$return[$i]["mod_acu_password"] = $row["mod_acu_password"];
                $return[$i]["imagen"] = $row["mod_acu_imagen"];
                $return[$i]["level"] = $row["mod_acu_level"];
                $return[$i]["gender"] = $row["mod_acu_gender"];
                $return[$i]["city"] = $row["mod_acu_city"];
                $return[$i]["ci"] = $row["mod_acu_ci"];
                $return[$i]["ciExt"] = $row["mod_acu_ci_ext"];
                $return[$i]["celular"] = $row["mod_acu_celular"];
                $return[$i]["recordDate"] = $row["mod_acu_record_date"];
                $return[$i]["type"] = $row["mod_acu_type"];
                $return[$i]["timezone"] = $row["mod_acu_timezone"];
                $return[$i]["locale"] = $row["mod_acu_locale"];
                $return[$i]["token"] = $row["mod_acu_token"];
                $return[$i]["code"] = $row["mod_acu_code"];
                $return[$i]["referred"] = $row["mod_acu_referred"];
                //$return[$i]["ent_id"] = $row["mod_acu_ent_id"];
                $return[$i]["state"] = $row["mod_acu_state"];
            }
            return $return;
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs);
    }

    public function add($vars = null)
    {
        //return $vars;
        $entitieId = $vars["entitieId"];
        $var = $vars["vars"];
        

        $user_name                  = ucfirst(strtolower($var["name"]));
        $user_fathersLastname       = ucfirst(strtolower($var["fathersLastname"]));
        $user_mothersLastname       = ucfirst(strtolower($var["mothersLastname"]));
        $user_gender                = $var["gender"];
        $user_ci                    = $var["ci"];
        $user_ext                   = $var["ext"];
        $user_email                 = $var["email"];
        $user_birthday              = $var["birthday"];
        $user_celular               = $var["celular"] ? $var["celular"] : "";
        $user_timezone              = $var["timezone"] ? $var["timezone"] : "America/La_Paz";
        $user_locale                = $var["locale"] ? $var["locale"] : "es_BO";
        $typeAccount                = $var["type"] ? $var["type"] : "app";
        $referred                   = $var["referred"] ? $var["referred"] : "";
        $city = $var["city"] ? $var["city"] : "";
        $today = $this->fmt->modules->dateFormat();
        $pw = $var["password"];
        $age = 0;
        $img = $var["img"];
        $level = "1";
        $token = "1";
        $code = "";

        
        
        if ($user_email != "no-email"){
            $returnEmail = $this->checkEmail($user_email);
            if ($returnEmail) {
                $return["Error"] = 1;
                $return["message"] = "error";
                $return["description"] = "account-exist";
                $return["code"] = "";
                $return["userId"] = $returnEmail;
                return $return;
                exit(0);
            }
        }
        $returnCI = $this->checkCI($user_ci, $user_ext);
        if ($returnCI) {
            $return["Error"] = 1;
            $return["message"] = "error";
            $return["description"] = "account-exist";
            $return["code"] = "";
            $return["userId"] = $returnCI;
            $return["userData"] = $this->dataAccount($returnCI);
            return $return;
            exit(0);
        }

        if (empty($code)) {
            $code = $this->codeAccount();
        }

        $ingresar = 'mod_acu_name,mod_acu_fathers_lastname,mod_acu_mothers_lastname,mod_acu_age_range,mod_acu_email,mod_acu_birthday_date,mod_acu_password,mod_acu_imagen,mod_acu_level,mod_acu_gender,mod_acu_ci,mod_acu_ci_ext,mod_acu_city,mod_acu_celular,mod_acu_record_date,mod_acu_type,mod_acu_timezone,mod_acu_locale,mod_acu_token,mod_acu_code,mod_acu_referred,mod_acu_ent_id,mod_acu_state';

        $valores  = "'" . $user_name . "','" .
            $user_fathersLastname . "','" .
            $user_mothersLastname . "','" .
            $age . "','" .
            $user_email . "','" .
            $user_birthday . "','" .
            $pw . "','" .
            $img . "','" .
            $level . "','" .
            $user_gender . "','" .
            $user_ci . "','" .
            $user_ext . "','" .
            $city . "','" .
            $user_celular . "','" .
            $today . "','" .
            $typeAccount . "','" .
            $user_timezone . "','" .
            $user_locale . "','" .
            $token . "','" .
            $code . "','".
            $referred."','".
            $entitieId."','1'";

        $sql = "insert into mod_accounts_users (" . $ingresar . ") values (" . $valores . ")";
        $this->fmt->querys->consult($sql, __METHOD__);

        $sql = "select max(mod_acu_id) as id from mod_accounts_users";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $row = $this->fmt->querys->row($rs);

        return $row["id"];
    }

    public function addAccount($vars = null)
    {
        //return $vars["vars"];
        $var = $vars["vars"]; 

        $user_name                  = ucfirst(strtolower($var["name"]));
        $user_fathersLastname       = ucfirst(strtolower($var["fathersLastname"]));
        $user_mothersLastname       = ucfirst(strtolower($var["mothersLastname"]));
        $user_gender                = $var["gender"];
        $user_ci                    = $var["ci"] ? $var["ci"] : 0;
        $user_ext                   = $var["ext"] ? $var["ext"] : "";
        $user_email                 = $var["email"] ? $var["email"] : "";
        $user_birdaydate            = $this->fmt->data->dbDate($var["birthday"]);
        $user_celular               = $var["celular"] ? $var["celular"] : 0;
        $user_timezone              = $var["timezone"] ? $var["timezone"] : "America/Lima";
        $user_locale                = $var["locale"] ? $var["locale"] : "es_PE";
        $typeAccount                = $var["type"] ? $var["type"] : "app";
        $referred                   = $var["referred"] ? $var["referred"] : "";
        $city = $var["city"] ? $var["city"] : "";
        $today = $this->fmt->modules->dateFormat();
        $pw = $var["password"];
        $age = 0;
        $img = $var["img"];
        $level = "1";
        $token = $var["token"] != "" ? $var["token"] : "1";
        $code = $var["code"] != "" ? $var["code"] : "";
        $entitieId = $vars["entitieId"] ? $vars["entitieId"] : 1;
        $state = $this->fmt->emptyReturn($var["state"], 0);


        $returnEmail = $this->checkEmail($user_email);
        

        if ($returnEmail) {
            $return["message"] = "error";
            $return["description"] = "account-exist";
            $return["code"] = "";
            $return["userId"] = $returnEmail;
            return $return;
            exit(0);
        }


        if (empty($code)) {
            $code = uniqid() . $this->codeAccount("general", "12");
        }

        $ingresar = 'mod_acu_name,mod_acu_fathers_lastname,mod_acu_mothers_lastname,mod_acu_age_range,mod_acu_email,mod_acu_birthday_date,mod_acu_password,mod_acu_imagen,mod_acu_level,mod_acu_gender,mod_acu_ci,mod_acu_ci_ext, mod_acu_city,mod_acu_celular,mod_acu_record_date,mod_acu_type,mod_acu_timezone,mod_acu_locale,mod_acu_token,mod_acu_code,mod_acu_ent_id,mod_acu_referred,mod_acu_state';

        $valores  = "'" . $user_name . "','" .
            $user_fathersLastname . "','" .
            $user_mothersLastname . "','" .
            $age . "','" .
            $user_email . "','" .
            $user_birdaydate . "','" .
            $pw . "','" .
            $img . "','" .
            $level . "','" .
            $user_gender . "','" .
            $user_ci . "','" .
            $user_ext . "','" .
            $city . "','" .
            $user_celular . "','" .
            $today . "','" .
            $typeAccount . "','" .
            $user_timezone . "','" .
            $user_locale . "','" .
            $token . "','" .
            $code . "','" .
            $entitieId . "','".$referred."','".$state."'";

        $sql = "insert into mod_accounts_users (" . $ingresar . ") values (" . $valores . ")";
        $this->fmt->querys->consult($sql, __METHOD__);

        $sql = "select max(mod_acu_id) as id from mod_accounts_users";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $row = $this->fmt->querys->row($rs);

        

        if ($typeAccount=="app"){
            $returnMail = $this->sendMailActivation(array(
                "name" => $user_name,
                "lastname" => $user_fathersLastname,
                "email" => $user_email,
                "key" => $code
            ));

            if ($returnMail!="send") {
                 return 0;
            }
        }
        
        return $row["id"];
    }

    public function codeAccount($mode = "number", $quantity = 6)
    {
        $code = $this->fmt->modules->createCode(array("mode" => $mode, "quantity" => $quantity));

        if ($this->checkCode($code)) {
            $this->codeAccount($mode, $quantity);
        } else {
            return $code;
        }
    }    
    
    public function codeCustomersPersons($mode = "number", $quantity = 6)
    {
        $code = $this->fmt->modules->createCode(array("mode" => $mode, "quantity" => $quantity));

        if ($this->checkCodeCustomersPersons($code)) {
            $this->codeCustomersPersons($mode, $quantity);
        } else {
            return $code;
        }
    }    
    
    public function codeCustomersEnterprises($mode = "number", $quantity = 6)
    {
        $code = $this->fmt->modules->createCode(array("mode" => $mode, "quantity" => $quantity));

        if ($this->checkCodeCustomersEnterprises($code)) {
            $this->codeCustomersEnterprises($mode, $quantity);
        } else {
            return $code;
        }
    }

    public function update($var = null)
    {
        $userId = $var["userId"];
        $vars = $var["vars"];
        $user_byrthdate = $vars["birthday"];
        $user_ci = $vars["ci"];
        $user_ext = $vars["ext"];
        $user_pw = base64_encode($vars["password"]);

        $sql = "UPDATE mod_accounts_users SET
					mod_acu_birthday_date='" . $user_byrthdate . "',
					mod_acu_ci='" . $user_ci . "', 
					mod_acu_password='" . $user_pw . "', 
					mod_acu_ci_ext='" . $user_ext . "' 
					WHERE mod_acu_id ='" . $userId  . "'";
        $this->fmt->querys->consult($sql);

        return true;
    }

    public function updateAccount($vars = null)
    {
        $var = $vars["vars"];
        $acuId = $var["acuId"];
        $name = ucwords(strtolower($var["name"]));
        $fathers_lastname = ucwords(strtolower($var["fathersLastname"]));
        $mothers_lastname = ucwords(strtolower($var["mothersLastname"]));
        $gender = $var["gender"];
        $ci = $var["ci"];
        $ext = $var["ext"];
        $email = $var["email"];
        $age_range = $var["ageRange"];
        $birthday_date = $var["birthday"];
        $celular = $var["celular"];
        $city = $var["city"];
        $referred = $var["referred"];


        $sql = "UPDATE mod_accounts_users SET
                    mod_acu_name ='" . $name . "',
                    mod_acu_fathers_lastname ='" . $fathers_lastname . "',
                    mod_acu_mothers_lastname ='" . $mothers_lastname . "',
                    mod_acu_age_range ='" . $age_range . "',
                    mod_acu_email ='" . $email . "',
                    mod_acu_birthday_date ='" . $birthday_date . "',
                    mod_acu_gender ='" . $gender . "',
                    mod_acu_ci ='" . $ci . "',
                    mod_acu_ci_ext ='" . $ext . "',
                    mod_acu_city ='" . $city . "',
                    mod_acu_celular ='" . $celular . "',
                    mod_acu_referred ='" . $referred . "'
        WHERE mod_acu_id ='" . $acuId  . "'";
        $this->fmt->querys->consult($sql);

        return  $acuId;
    }

    public function updateData(Int $acuId = null, String $column = null, String $value = null)
    {
        $sql = "UPDATE mod_accounts_users SET
                    " . $column . " ='" . $value . "'
                WHERE mod_acu_id ='" . $acuId  . "'";
        $this->fmt->querys->consult($sql);

        return  1;
    }

    public function deleteRelationServises($acuId = null)
    {
        $this->fmt->modules->deleteRelation(array("from" => "mod_accounts_services", "column" => "mod_acu_sv_acu_id", "item" => $acuId));
    }

    public function checkEmail($email = null)
    {
        if ($email == null) {
            return 0;
        }
        $sql = "SELECT * FROM mod_accounts_users WHERE mod_acu_email='" . $email . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);

        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return $row["mod_acu_id"];
        } else {
            return 0;
        }
    }

    public function sendMailActivation(array $var = null)
    {
        //return $var;
        $name = $var["name"];
        $lastname = $var["lastname"];
        $email = $var["email"];
        $key = base64_encode($email . "&" . $var["key"]);

        $subject = "Activación de cuenta";

        // building mail
        $indexMail = file_get_contents(_PATH_NUCLEO . "views/mail/mail-mensaje.htm");
        $reset = file_get_contents(_PATH_HOST . "views/mail/mail-activation.html");

        $linkLogo = $this->fmt->options->getItem("path_logo");
        $pathActivation = $this->fmt->options->getItem("path_activation");

        $logo = '<img width="200px" src="' .$linkLogo.'">';

        $link = $pathActivation . "activate?" . $key;

        $footer = $this->fmt->options->getItem("footer");


        $textoMail = str_replace("{{_NAME}}", $name. ' ' . $lastname, $reset);
        $textoMail = str_replace("{{_LINK}}", $link, $textoMail);


        $bodyMail = str_replace("#logo#", $logo, $indexMail);
        $bodyMail = str_replace("#footer#", $footer, $bodyMail);
        $bodyMail = str_replace("#body#", $textoMail, $bodyMail);


        return $this->fmt->mails->send(array(
            'email' => $email,
            'name' => $name . " " . $lastname,
            'subject' => $subject,
            'setFromMail' => _EMAIL_USER,
            'setFromName' => _EMAIL_USER_NAME,
            'body' => $bodyMail
        ));
    }

    public function checkCode($code = null)
    {
        if ($code == null) {
            return 0;
        }
        $sql = "SELECT * FROM mod_accounts_users WHERE mod_acu_code='" . $code . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);

        if ($num > 0) {
            return 1;
        } else {
            return 0;
        }
    }    
    
    public function checkCodeCustomersPersons($code = null)  
    {
        if ($code == null) {
            return 0;
        }
        $sql = "SELECT * FROM mod_customers_persons WHERE mod_cpe_code='" . $code . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);

        if ($num > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    public function checkCodeCustomersEnterprises($code = null)  
    {
        if ($code == null) {
            return 0;
        }
        $sql = "SELECT * FROM mod_customers_enterprises WHERE mod_cen_code='" . $code . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);

        if ($num > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    public function checkBirthdate($userId = null)
    {
        $sql = "SELECT mod_acu_birthday_date FROM mod_accounts_users WHERE mod_acu_id='" . $userId . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);

        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            $bd = $row["mod_acu_birthday_date"];

            if ($bd != "0000-00-00") {
                return $row["mod_acu_birthday_date"];
            } else {
                return 0;
            }
        } else {
            return 0;
        }
    }

    public function checkCI($ci = null, $ext = null)
    {
        if ($ci == null) {
            return 0;
        }

        if ($ext == null) {
            $ex = "AND mod_acu_ci_ext='" . $ext . "'";
        }else{
            $ex = "";
        }

        $sql = "SELECT * FROM mod_accounts_users WHERE mod_acu_ci='" . $ci . "' ".$ex;
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return $row["mod_acu_id"];
        } else {
            return 0;
        }
    }

    public function checkCodeId($userId = null)
    {
        if ($userId == null) {
            return 0;
        }
        $sql = "SELECT * FROM mod_accounts_users WHERE mod_acu_id='" . $userId . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return $row["mod_acu_code"];
        } else {
            return 0;
        }
    }

    public function validateUser($vars = null)
    {
        //return $vars;
        $email = $vars['email'];
        $pw = $vars['password'];
        $password = base64_encode($pw);

        $sql = "SELECT mod_acu_id FROM mod_accounts_users WHERE mod_acu_email='" . $email . "' AND mod_acu_password='" . $password . "' AND mod_acu_state=1";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return $row["mod_acu_id"];
        } else {
            return 0;
        }
    }

    public function userValidate($vars = null)
    {
        //return $vars;
        $email = $vars['email'];
        $pw = $vars['password'];
        $password = base64_encode($pw);

       $sql = "SELECT mod_acu_id,mod_acu_code FROM mod_accounts_users WHERE mod_acu_email='" . $email . "'  AND mod_acu_state='1'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $sql2 = "SELECT mod_acu_id,mod_acu_code, mod_acu_name, mod_acu_fathers_lastname, mod_acu_imagen, mod_acu_level, mod_acu_json FROM mod_accounts_users WHERE mod_acu_email='" . $email . "' AND mod_acu_password='" . $password . "' AND mod_acu_state='1'";
            $rs2 = $this->fmt->querys->consult($sql2, __METHOD__);
            $num2 = $this->fmt->querys->num($rs2);
            if ($num2 > 0) {
                $row2 = $this->fmt->querys->row($rs2);
                $acuId = $row2["mod_acu_id"];
                $rolId = $this->accountRol($acuId,'1');
                $name = $row2["mod_acu_name"] . " " . $row2["mod_acu_fathers_lastname"];
                $rtn["Error"] = 0;
                $rtn["account"]["acuId"] = $row2["mod_acu_id"];
                $rtn["account"]["email"] = $email;
                $rtn["account"]["fullname"] =  $name;
                $rtn["account"]["initial"] =  $this->fmt->users->initial($name);
                $rtn["account"]["initialName"] =  $row2["mod_acu_name"];
                $rtn["account"]["img"] =  $this->fmt->files->imgReturn($row2["mod_acu_imagen"]);
                $rtn["account"]["level"] =  $row2["mod_acu_level"];
                $dataAcu = $this->dataRol($rolId);
                $rtn["account"]["rol"] =  $dataAcu;
                $rtn["account"]["json"] =  $row2["mod_acu_json"];
                //$rtn["account"]["rol"] =  $this->dataRol($acuId);

                $count = 0;

                //return $this->createToken(array('acuId' => $acuId, 'type' => 'app', 'token' => $code));

                $grant_type = $this->fmt->auth->getInput('grant_type');
                $clientId = $this->fmt->auth->getInput('client_id');

                $accessToken = base64_encode($clientId . "." . $acuId . "." . $grant_type . "." . uniqid(microtime(), true));
                $refreshToken = md5(uniqid(microtime(), true));

                if ($this->createToken(array('acuId' => $acuId, 'type' => 'accessToken', 'token' => $accessToken)) == 0) {
                    $count++;
                }
                if ($this->createToken(array('acuId' => $acuId, 'type' => 'refreshToken', 'token' => $refreshToken)) == 0) {
                    $count++;
                }

                $rtn["accountToken"]["accessToken"] =  $accessToken;
                $rtn["accountToken"]["refreshToken"] =  $refreshToken;
                $rtn["client"] =  $this->dataClient($acuId);
                $arrayCpe = $this->dataClient($acuId);
                $rtn["enterprises"] =  $this->dataEnterprise($arrayCpe["id"]);

                if ($count == 0) {
                    return $rtn;
                } else {
                    $rtn["Error"] = 1;
                    $rtn["type"] = 0;
                    $rtn["message"] = "access token create error";
                    return $rtn;
                }
            } else {
                $rtn["Error"] = 1;
                $rtn["type"] = 1;
                $rtn["message"] = "Password incorrect";
                return $rtn;
            }
        } else {
            $rtn["Error"] = 1;
            $rtn["type"] = 2;
            $rtn["message"] = "Email incorrect";
            return $rtn;
        }
    }

    public function accountRol(int $acuId = null, int $entId = null){

        $sql = "SELECT mod_acu_user_rol_rol_id FROM mod_accounts_users_roles WHERE mod_acu_user_rol_acu_id='" . $acuId . "' AND mod_acu_user_rol_ent_id='" . $entId . "'";
        $rs =$this->fmt->querys->consult($sql,__METHOD__);
        $num=$this->fmt->querys->num($rs);
        if($num>0){
            $row=$this->fmt->querys->row($rs);
            return $row["mod_acu_user_rol_rol_id"];
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs);
        
    }

    public function createUserToken($userId = null, $type = null, $token = null)
    {
        $ua = $this->fmt->users->getBrowser();
        if (($userId != null) && ($type != null) && ($token != null)) {
            $enter = "mod_atk_user_id,mod_atk_type,mod_atk_token,mod_atk_date,mod_atk_dates_browser"; // 1. local 2.fb 3.gl 4. in
            $values  = "'" . $userId . "','" . $type . "','" . $token . "','" . $this->fmt->modules->dateFormat() . "','" . $ua['name'] . "," . $ua['version'] . "," . $ua["platform"] . ":" . $ua['userAgent'] . "'";
            $sql = "insert into mod_accounts_token (" . $enter . ") values (" . $values . ")";
            $this->fmt->querys->consult($sql, __METHOD__);
            return 1;
        } else {
            return 0;
        }
    }


    public function createToken($vars = null)
    {
        //return $vars;
        $acuId = $vars['acuId'];
        $type = $vars['type'];
        $token = $vars['token'];

        $ua = $this->fmt->users->getBrowser();
        if (($acuId != null) && ($type != null) && ($token != null)) {
            $enter = "mod_atk_user_id,mod_atk_type,mod_atk_token,mod_atk_date,mod_atk_dates_browser"; // 1. local 2.fb 3.gl 4. in
            $values  = "'" . $acuId . "','" . $type . "','" . $token . "','" . $this->fmt->modules->dateFormat() . "','" . $ua['name'] . "," . $ua['version'] . "," . $ua["platform"] . ":" . $ua['userAgent'] . "'";
            $sql = "insert into mod_accounts_token (" . $enter . ") values (" . $values . ")";
            $this->fmt->querys->consult($sql, __METHOD__);
            return 1;
        } else {
            return 0;
        }
    }

    public function getTokenUser($userId, $type)
    {
        $sql = "SELECT mod_atk_token FROM mod_accounts_token WHERE mod_atk_type='" . $type . "' AND mod_atk_user_id='" . $userId . "'";
        $rs = $this->fmt->querys->consult($sql);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return $row["mod_atk_token"];
        } else {
            return 0;
        }
        $this->fmt->querys->leave();
    }

    public function getUserToken($token, $type)
    {
        $sql = "SELECT mod_atk_user_id FROM mod_accounts_token WHERE mod_atk_type='" . $type . "' AND mod_atk_token='" . $token . "'";
        $rs = $this->fmt->querys->consult($sql);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return $row["mod_atk_user_id"];
        } else {
            return 0;
        }
        $this->fmt->querys->leave();
    }

    public function addresses($userId = null)
    {
        require_once(_PATH_NUCLEO . "modules/logistics/controllers/class/class.logistics.php");
        $logistics = new LOGISTICS($this->fmt);
        $sql = "SELECT DISTINCT mod_add_id,mod_add_name,mod_add_alias,mod_add_coord FROM mod_accounts_addresses, mod_addresses WHERE mod_acu_add_acu_id='" . $userId . "' AND mod_add_state=1  ORDER BY mod_acu_add_order ASC";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            for ($i = 0; $i < $num; $i++) {
                $row = $this->fmt->querys->row($rs);
                $id = $row["mod_add_id"];
                $return[$i]["id"] = $row["mod_add_id"];
                $return[$i]["name"] = $row["mod_add_name"];
                $return[$i]["alias"] = $row["mod_add_alias"];
                $return[$i]["coord"] = $row["mod_add_coord"];
                $perimeterId = $logistics->getRelationAddressDelivery($id);
                $dataPerimeter = $logistics->dataPerimeter($perimeterId);
                $return[$i]["perimeterId"] =  $perimeterId;
                $return[$i]["perimeterCost"] =  $dataPerimeter["cost"];
                $return[$i]["perimeterName"] =  $dataPerimeter["name"];
            }
            return  $return;
        } else {
            return 0;
        }
        $this->fmt->query->leave($rs);
    }

    public function invoiceData($userId = null)
    {

        $sql = "SELECT DISTINCT * FROM mod_accounts_invoices_data WHERE mod_acu_invd_acu_id='" . $userId . "' AND mod_acu_invd_state > 0  ORDER BY mod_acu_invd_order ASC";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            for ($i = 0; $i < $num; $i++) {
                $row = $this->fmt->querys->row($rs);
                $id = $row["mod_acu_invd_id"];
                $return[$i]["id"] = $id;
                $return[$i]["razonSocial"] = $row["mod_acu_invd_razon_social"];
                $return[$i]["nit"] = $row["mod_acu_invd_nit"];
            }
            return  $return;
        } else {
            return 0;
        }
        $this->fmt->query->leave($rs);
    }

    public function validateUserToken($vars = null)
    {
        $access_token = $vars['access_token'];
        $refresh_token = $vars['refresh_token'];
        $idEntitie = $vars['idEntitie'];

        $decode = base64_decode($access_token);
        $arrayUserDates = explode(".", $decode);
        $userId = $arrayUserDates[1];
        $rolId =  $arrayUserDates[2];

        $sql = "SELECT mod_atk_user_id FROM  mod_accounts_token WHERE mod_atk_user_id='" . $userId . "' AND  mod_atk_type='access_token' AND mod_atk_token='" . $access_token . "'";
        $rs = $this->fmt->querys->consult($sql);
        $num = $this->fmt->querys->num($rs);
        if ($num == 0) {
            return 0;
        }
        $this->fmt->querys->leave($rs);

        $sql2 = "SELECT mod_atk_user_id FROM  mod_accounts_token WHERE mod_atk_user_id='" . $userId . "' AND  mod_atk_type='refresh_token' AND mod_atk_token='" . $refresh_token . "'";
        $rs2 = $this->fmt->querys->consult($sql2);
        $num2 = $this->fmt->querys->num($rs2);

        if ($num2 > 0) {
            return $userId;
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs2);
    }

    public function validateTokenAccess($var = null)
    {
        //return $var;
        $access_token = $var['accessToken'];
        $refresh_token = $var['refreshToken'];
        $idEntitie = $var['idEntitie'];

        $decode = base64_decode($access_token);
        $arrayUserDates = explode(".", $decode);
        $userId = $arrayUserDates[1];


        $sql = "SELECT mod_atk_user_id FROM  mod_accounts_token WHERE mod_atk_user_id='" . $userId . "' AND  mod_atk_type='accessToken' AND mod_atk_token='" . $access_token . "'";
        $rs = $this->fmt->querys->consult($sql);
        $num = $this->fmt->querys->num($rs);
        if ($num == 0) {
            return 0;
        }
        $this->fmt->querys->leave($rs);

        $sql2 = "SELECT mod_atk_user_id FROM  mod_accounts_token WHERE mod_atk_user_id='" . $userId . "' AND  mod_atk_type='refreshToken' AND mod_atk_token='" . $refresh_token . "'";
        $rs2 = $this->fmt->querys->consult($sql2);
        $num2 = $this->fmt->querys->num($rs2);

        if ($num2 > 0) {
            return $userId;
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs2);
    }

    public function decodeTokenAccess($token = null)
    {
        $arr = explode(".", base64_decode($token));

        $vars["client_id"] = $arr[0];
        $vars["userId"] = $arr[1];
        $vars["grant_type"] = $arr[2];

        return $vars;
    }

    public function encodeTokenAccess($vars = null)
    {
        $client_id  = $vars["client_id"];
        $userId = $vars["userId"];
        $grant_type = $vars["grant_type"];
        return base64_encode($clientId . "." . $userId . "." . $grant_type . "." . uniqid(microtime(), true));
    }

    public function sendCode($vars = null)
    {

        $userId = $vars["userId"];
        $mailLogo = $vars["mailLogo"];
        $mailFooter = $vars["mailFooter"];
        $email = $vars["email"];
        $name = $vars["name"];
        $mailSubject = $vars["mailSubject"];
        $setFromName = $vars["setFromName"];

        $activationHtml = file_get_contents(_PATH_NUCLEO . "views/mail/mail-activation.htm");
        $code = $this->checkCodeId($userId);
        $body = str_replace("#CODE#", $code, $activationHtml);
        //$body = str_replace("#link#", _PATH_WEB."activation/user/". $accessToken,$activationHtml);

        $mailHtml = file_get_contents(_PATH_NUCLEO . "views/mail/mail-mensaje.htm");

        $mensajeMail = str_replace("#logo#", $mailLogo, $mailHtml);
        $mensajeMail = str_replace("#body#", $body, $mensajeMail);
        $mensajeMail = str_replace("#footer#", $mailFooter, $mensajeMail);



        $return = $this->fmt->mails->send(array(
            "Error" => 0,
            'email' => $email,
            'name' => $name,
            'subject' => $mailSubject,
            'setFromMail' => _EMAIL_USER,
            'setFromName' =>  $setFromName,
            'body' => $mensajeMail
        ));

        if ($return) {
            return 1;
        } else {
            return 0;
        }
    }

    public function realationAccountServices($acuId = null)
    {
        $sql = "SELECT mod_sv_id, mod_sv_name FROM mod_accounts_services,mod_services WHERE mod_acu_sv_acu_id='" . $acuId . "' AND mod_acu_sv_sv_id=mod_sv_id AND mod_sv_state > 0 ORDER BY mod_acu_sv_order ASC";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            for ($i = 0; $i < $num; $i++) {
                $row = $this->fmt->querys->row($rs);
                $svId = $row["mod_sv_id"];
                $return[$i]["id"] = $svId;
                $return[$i]["name"] = $row["mod_sv_name"];
            }
            return $return;
        } else {
            return 0;
        }
    }

    //invoices
    public function createInvoiceData(array $var = null)
    {
        $acuId = $var['acuId'];
        $razonSocial = $var['razonSocial'];
        $nit = $var['nit'];
        $invoiceData = $this->haveInvoiceData($acuId, $nit);
        if ($invoiceData == 0) {
            $insert = 'mod_acu_invd_acu_id,mod_acu_invd_razon_social,mod_acu_invd_nit,mod_acu_invd_order';
            //return $this->invoiceLastOrder($acuId);
            $values  = "'" . $acuId . "','" . $razonSocial . "','" . $nit . "','" . $this->invoiceLastOrder($acuId) . "'";
            $sql = "insert into mod_accounts_invoices_data (" . $insert . ") values (" . $values . ")";
            $this->fmt->querys->consult($sql, __METHOD__);

            $sql = "select max(mod_acu_invd_id) as id from mod_accounts_invoices_data";
            $rs = $this->fmt->querys->consult($sql, __METHOD__);
            $row = $this->fmt->querys->row($rs);
            return $row["id"];
        } else {
            return $invoiceData;
        }
    }

    public function haveInvoiceData(int $acuId = null, int  $nit = null)
    {
        $sql = "SELECT mod_acu_invd_id FROM mod_accounts_invoices_data WHERE  mod_acu_invd_nit='" . $nit . "' AND mod_acu_invd_acu_id='" . $acuId . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return  $row['mod_acu_invd_id'];
        } else {
            return 0;
        }
    }

    public function invoiceLastOrder(int $acuId = null)
    {
        $sql = "SELECT mod_acu_invd_order FROM mod_accounts_invoices_data WHERE  mod_acu_invd_acu_id='" . $acuId . "' ORDER BY mod_acu_invd_order ASC LIMIT 0,1";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return  $row['mod_acu_invd_order'];
        } else {
            return 0;
        }
    }

    public function fullName($acuId, $lastname = "0")
    {
        $sql = "SELECT mod_acu_name, mod_acu_fathers_lastname,mod_acu_mothers_lastname FROM mod_accounts_users WHERE mod_acu_id='" . $acuId . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            $last = $row["mod_acu_fathers_lastname"] . " " . $row["mod_acu_mothers_lastname"];
            if ($lastname == "1") {
                $lastname = $row["mod_acu_fathers_lastname"];
            } else {
                $lastname = $last;
            }
            return $row["mod_acu_name"] . " " . $lastname;
        } else {
            return "";
        }
    }

    public function registerSignUp(array $var = null)
    {
        //return $var;
        $vars = $var["vars"];
        $company = $vars["inputCompany"] ? $vars["inputCompany"] : "";
        $entitieId = $vars["entitieId"];
        $name = $vars["inputName"];
        $pw = base64_encode($vars["inputPassword"]);
        $arrayLastName = explode(" ", $vars["inputLastname"]);
        $fathersLastname = $arrayLastName[0];
        $mothersLastname = $arrayLastName[1];
        $gender = $vars["inputGender[]"];
        $email = $vars["inputEmail"];
        $type = $vars["type"];
        $locale = $vars["locale"];
        $timezone = $vars["timezone"];
        $birdaydate = $vars["inputDay"] . "-" . $vars["inputMonth"] . "-" . $vars["inputYear"];

        $vari["entitieId"] = $entitieId;
        $vari["vars"] = array(
            "name" => $name,
            "fathersLastname" => $fathersLastname,
            "mothersLastname" => $mothersLastname,
            "gender" => $gender,
            "email" => $email,
            "type" => $type,
            "password" => $pw,
            "locale" => $locale,
            "timezone" => $timezone,
            "birthday" => $birdaydate
        );

        $acuId = $this->addAccount($vari);
        
        if (!is_int($acuId)) return 0;
        //if ($acuId != 0){

        //return "acu:".$acuId ;
        
        $vars["acuId"] = $acuId;
        $vars["entitieId"] = $entitieId;
        $cpeId = $this->createCustomersPersons($vars);
        if (!is_int($cpeId)) return 0;

        $rol = $this->addRoleToAccount(["acuId"=>$acuId, "rolId"=>1, "entitieId"=>$entitieId]); 
        //return "rol:".$rol;
        
        if (!is_int($rol)) return 0;

        $vars["cpeId"] = $cpeId;
        $vars["inputUsername"] = $company;

        //return $cpeId."-".$company;
        
        if (!empty($company)){
            $cenId = $this->createCustomersEnterprises($vars);
            if (!is_int($cenId)) return 0;
        }
    
        return 'send';
    }

    public function createCustomersPersons(array $var = null){
        //return $var;
        $entitieId = $var["entitieId"];
        $acuId = $var["acuId"];
        $name = $var["inputName"];
        $lastname = $var["inputLastname"];
        $email = $var["inputEmail"];
        $code =  $var["code"] ? $var["code"] : 'MCP'.$this->codeCustomersPersons();

        $today = $this->fmt->modules->dateFormat();
        $userId = $var["userId"] ? $var["userId"] : 0;

        $insert = "mod_cpe_acu_id,
        mod_cpe_name,
        mod_cpe_lastname,
        mod_cpe_email,
        mod_cpe_code,
        mod_cpe_register_date,
        mod_cpe_user_id,
        mod_cpe_ent_id,
        mod_cpe_state";
        $values ="'" .$acuId. "','".$name."','".$lastname."','".$email."','".$code."','".$today."','".$entitieId."','".$userId."','1'"; ;
        $sql= "insert into mod_customers_persons (".$insert.") values (".$values.")";
        $this->fmt->querys->consult($sql,__METHOD__);

        $sql = "select max(mod_cpe_id) as id from mod_customers_persons";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $row = $this->fmt->querys->row($rs);

        return $row["id"];
    }

    public function createCustomersEnterprises(array $var = null){
        //return $var;
        $entitieId = $var["entitieId"] ? $var["entitieId"] : 1;
        $cpeId = $var["cpeId"];
        $name = $var["inputName"];
        $username = $var["inputUsername"];
        $description = $var["inputDescription"] ? $var["inputDescription"] : "";
        $img = $var["inputImg"] ? $var["inputImg"] : "";
        $code =  $var["code"] ? $var["code"] : 'N'.$this->codeCustomersPersons();

        $today = $this->fmt->modules->dateFormat();
        $userId = $var["userId"] ? $var["userId"] : 0;

        if ($username == ""){
            return 0;
        }

        $insert = "mod_cen_cpe_id,
        mod_cen_name,
        mod_cen_username,
        mod_cen_code,
        mod_cen_description,
        mod_cen_img,
        mod_cen_register_date,
        mod_cen_user_id,
        mod_cen_ent_id,
        mod_cen_state";
        $values ="'" .$cpeId. "','".$name."','".$username."','".$code."','".$description."','".$img."','".$today."','".$entitieId."','".$userId."','1'"; ;
        $sql= "insert into mod_customers_enterprises (".$insert.") values (".$values.")";
        $this->fmt->querys->consult($sql,__METHOD__);

        $sql = "select max(mod_cen_id) as id from mod_customers_enterprises";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $row = $this->fmt->querys->row($rs);

        return $row["id"];
    }

    public function emailExists(string $email = null)
    {
        $sql = "SELECT mod_acu_id FROM mod_accounts_users WHERE mod_acu_email='" . $email . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            return 1;
        } else {
            return 0;
        }
    }    
    
    public function companyExists(array $var = null)
    {
        $username = $var["company"];

        if ($this->fmt->validations->username($username)){
            $sql = "SELECT mod_cen_id FROM mod_customers_enterprises WHERE mod_cen_username='" . $username. "'";
            $rs = $this->fmt->querys->consult($sql, __METHOD__);
            $num = $this->fmt->querys->num($rs);
            if ($num > 0) {
                return 1;
            } else {
                return 0;
            }
        }else{
            return "error";
        }
         
       
    }

    public function registerPassword(string $key = null, string $password = null){
        //return $key.":".$password;

        $key = base64_decode($key);
        $array = explode("&", $key);
        $email = $array[0];
        $code = $array[1];
        $pw = base64_encode($password);

        if (empty($email) || empty($code)) {
            return 0;
        } 

       $sql = "UPDATE mod_accounts_users  SET
               mod_acu_password='" . $pw. "'
               WHERE  mod_acu_email='" . $email . "' AND mod_acu_code='" . $code . "' AND mod_acu_state > 0";
       $this->fmt->querys->consult($sql);

       //register
       //$dataRegister = $this->userValidate(array("email"=>$email,"password"=>$password));
        $rtn ["Error"] = 0;
        $rtn ["email"] = $email;
       return $rtn;

    }

    public function activateAccountCode(string $key = null)
    {
        $key = base64_decode($key);
        $array = explode("&", $key);
        $email = $array[0];
        $code = $array[1];

        if (empty($email) || empty($code)) {
            return 0;
        } 

        $sql = "SELECT mod_acu_id FROM mod_accounts_users WHERE mod_acu_email='" . $email . "' AND mod_acu_code='" . $code . "' AND mod_acu_state='0' ";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);
        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            $acuId = $row["mod_acu_id"];
            return $this->updateData($acuId, "mod_acu_state", "1");
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs);


        return $key;
    }

    public function loginSignIn(array $var = null)
    {
        $vars = $var["vars"];

        return $this->userValidate($vars);
    }

    public function setLevelAccount(array $var = null)
    {
        //return $var;
        $acuId = $var["acuId"];
        $level = $var["level"];
        //$entitieId = $var["entitieId"];

        $sql = "UPDATE mod_accounts_users SET
               mod_acu_level='" . $level . "'
               WHERE mod_acu_id='" . $acuId . "' AND mod_acu_state = '1'";
        $this->fmt->querys->consult($sql);

        return $level;
    }

    public function checkEmailType(string $email, string $type)
    {
        //return $email.",".$type;
        if ($email == null) {
            return "error";
        }
        $sql = "SELECT * FROM mod_accounts_users WHERE mod_acu_email='" . $email . "' AND mod_acu_type='" . $type . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);

        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return $row["mod_acu_id"];
        } else {
            return 0;
        }
    }

    public function checkType(string $email){
        //return $email.",".$type;
        $sql = "SELECT mod_acu_type FROM mod_accounts_users WHERE mod_acu_email='" . $email . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);

        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return $row["mod_acu_type"];
        } else {
            return 0;
        }
    }

    public function emaintToId(string $email){
        //return $email.",".$type;
        $sql = "SELECT mod_acu_id FROM mod_accounts_users WHERE mod_acu_email='" . $email . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);

        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return $row["mod_acu_id"];
        } else {
            return 0;
        }
    }

    public function checkCodeSocial(string $email){
        //return $email.",".$type;
        $sql = "SELECT mod_acu_code FROM mod_accounts_users WHERE mod_acu_email='" . $email . "'";
        $rs = $this->fmt->querys->consult($sql, __METHOD__);
        $num = $this->fmt->querys->num($rs);

        if ($num > 0) {
            $row = $this->fmt->querys->row($rs);
            return $row["mod_acu_code"];
        } else {
            return 0;
        }
    }

    public function checkBirthday(string $email){
        //return $var;
        $sql = "SELECT mod_acu_birthday_date,mod_acu_id FROM mod_accounts_users WHERE mod_acu_email='" . $email . "'";
        $rs =$this->fmt->querys->consult($sql,__METHOD__);
        $num=$this->fmt->querys->num($rs);
        if($num>0){
            $row = $this->fmt->querys->row($rs);
            $date = $row["mod_acu_birthday_date"];

            if ($date == "" || $date == "0000-00-00") {
                return 0;
            } else {
                return $row["mod_acu_id"];
            }
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs);
    }

    public function createAccountSocial(array $var = null)
    {
        //return $var;
        $vars = $var["vars"];
        $email = $vars["email"];
        $type = $vars["type"];
        $code = $vars["code"];
        $token = $vars["token"];
        $img = $vars["img"];
        $locale = $vars["locale"];
        $timezone = $vars["timezone"];
        $mode = $vars["mode"];

        

        if ($email != null && !empty($email)) {
            //return "ingresamos mail";
            if (!$this->emailExists($email)) {
                //create account

                $name = $vars["name"];
                $pw = "";
                $arrayLastName = explode(" ", $vars["lastname"]);
                $fathersLastname = $arrayLastName[0];
                $mothersLastname = $arrayLastName[1];
                $gender = '';
                
                
                $birdaydate = '';
                $vari["entitieId"] = $vars["entitieId"];

                $vari["vars"] = array(
                    "name" => $name,
                    "fathersLastname" => $fathersLastname,
                    "mothersLastname" => $mothersLastname,
                    "gender" => $gender,
                    "email" => $email,
                    "type" => $type,
                    "code" => $code,
                    "password" => $pw,
                    "token" => $token,
                    "img" => $img,
                    "locale" => $locale,
                    "timezone" => $timezone,
                    "birdaydate" => $birdaydate,
                    "state" => 1
                );
                
                $stateAcu =   $this->addAccount($vari);

                if ($mode == "business"){
                    $error = 3;
                    $message = 'error, ask for name bussiness';
                }else{
                    $error = 2;
                    $message = 'ok';
                }

                if (!is_array($stateAcu)){
                    $rtn["Error"]  = $error;
                    $rtn["id"] = $stateAcu;
                    $rtn["message"] = $message;
                }else{
                    //Si hay algun error;
                    $rtn = $stateAcu;
                }

            }else{
                //account exist
                //return "account exist";
                $stateBirthday = $this->checkBirthday($email);
                $stateType = $this->checkType($email);
                $acuId = $this->emaintToId($email);
                $cpeId = $this->checkCustomerPerson($acuId);
                $cenId = $this->checkCustomerEnterprise($cpeId);

                //return $stateType.":".$type;
                
                if ($stateType != $type){
                    $sql = "UPDATE mod_accounts_users SET
                            mod_acu_type='" . $type. "',
                            mod_acu_imagen='" . $img. "',
                            mod_acu_token='" . $token. "',
                            mod_acu_code='" . $code. "'
                            WHERE mod_acu_id= '" . $acuId . "' ";
                    $this->fmt->querys->consult($sql);
                }else{
                    if (!$this->checkCodeSocial($email)==$code){
                        $sql = "UPDATE mod_accounts_users SET
                            mod_acu_imegen='" . $img. "',
                            mod_acu_token='" . $token. "',
                            mod_acu_code='" . $code. "'
                        WHERE mod_acu_id= '" . $acuId . "' ";
                        $this->fmt->querys->consult($sql);
                    }
                }


                if ($mode == "business"){
                     if ($cenId){
                        $arrayData = $this->dataId($acuId);
                        $response["email"] = $email;
                        $response["password"]  = base64_decode($arrayData["mod_acu_password"]);
                        return $this->userValidate($response);
                     }else{
                        $rtn["Error"] = 3;
                        $rtn["id"] = $acuId;
                        $rtn["message"] = "error, ask for name bussiness";
                        return $rtn;
                     }
                }

                if ($stateBirthday){
                    //cuentaCompleta
                    //logearse
                    $arrayData = $this->dataId($acuId);
                    $response["email"] = $email;
                    $response["password"]  = base64_decode($arrayData["mod_acu_password"]);
                    return $this->userValidate($response);
                }else{
                    $rtn["Error"] = 2;
                    $rtn["id"] = $acuId;
                    $rtn["message"] = "error, ask for birthday";
                    return $rtn;
                }

    
            } 
            return $rtn;
        
        }else{
            $rtn["Error"] = 1;
            $rtn["message"] = "error, email no exist";
            return $rtn;
        }
    }

    public function checkCustomerPerson(string $acuId = null)
    {
        $sql = "SELECT * FROM mod_customers_persons WHERE mod_cpe_acu_id='" . $acuId . "'";
        $rs =$this->fmt->querys->consult($sql,__METHOD__);
        $num=$this->fmt->querys->num($rs);
        if($num>0){
            return 1;
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs);
    }

    public function checkCustomerEnterprise(string $cpeId = null)
    {
        //return $var;
        $sql = "SELECT * FROM mod_customers_enterprises WHERE mod_cen_cpe_id='" . $cpeId . "'";
        $rs =$this->fmt->querys->consult($sql,__METHOD__);
        $num=$this->fmt->querys->num($rs);
        if($num>0){
            return 1;
        } else {
            return 0;
        }
        $this->fmt->querys->leave($rs);
    }

    public function registerSocialOthers(array $var = null)
    {
        
        $vars = $var["vars"];
        $item = $vars["item"];
        $birthday = $vars["birthday"];
        $gender = $vars["gender"];
        $genderCustom = $vars["genderCustom"];
        $email = $vars["email"];
        $code = $vars["code"];

        if (empty($gender) && !empty($genderCustom)){
            $gender = $genderCustom;
        }

        $sql = "SELECT mod_acu_id FROM mod_accounts_users WHERE mod_acu_id='".$item."' AND mod_acu_email='".$email."' AND mod_acu_code='".$code."' ";
        $rs =$this->fmt->querys->consult($sql,__METHOD__);
        $num=$this->fmt->querys->num($rs);
        if($num>0){
             
            /* $sql = "UPDATE mod_accounts_users SET
                    mod_acu_birthday_date='" . $birthday. "',
                    mod_acu_gender = '".$gender."';  */
           $sql = "UPDATE mod_accounts_users SET
                   mod_acu_birthday_date='" . $birthday. "',
                   mod_acu_gender = '".$gender."'
                   WHERE mod_acu_id= '" . $item . "' ";
           $this->fmt->querys->consult($sql);

            $arrayData = $this->dataId($item);
            $response["email"] = $email;
            $response["password"]  = base64_decode($arrayData["mod_acu_password"]);
            return $this->userValidate($response);
             
        } else {
            $rtn["Error"] = 1;
            $rtn["mensaje"] = "error, account not exist";
        }
        $this->fmt->querys->leave($rs);
        return $rtn;
    }

    public function registerSocialBusiness(array $var = null)
    {
        //return $var;
        $vars = $var["vars"];
        $company = $vars["company"];
        $item = $vars["item"];
        $birthday = $vars["birthday"];
        $gender = $vars["gender"];
        $genderCustom = $vars["genderCustom"];
        $email = $vars["email"];
        $code = $vars["code"];
        $entitieId = $vars["entitieId"];

        if (empty($gender) && !empty($genderCustom)){
            $gender = $genderCustom;
        }

        $sql = "SELECT mod_acu_id FROM mod_accounts_users WHERE mod_acu_id='".$item."' AND mod_acu_email='".$email."' AND mod_acu_code='".$code."' ";
        $rs =$this->fmt->querys->consult($sql,__METHOD__);
        $num=$this->fmt->querys->num($rs);
        if($num>0){
             
            /* $sql = "UPDATE mod_accounts_users SET
                    mod_acu_birthday_date='" . $birthday. "',
                    mod_acu_gender = '".$gender."';  */
            $sql = "UPDATE mod_accounts_users SET
                    mod_acu_birthday_date='" . $birthday. "',
                    mod_acu_gender = '".$gender."'
                    WHERE mod_acu_id= '" . $item . "' ";
            $this->fmt->querys->consult($sql);
            
            $acuId = $item;

            if (is_int($acuId)) return 0;
            //if ($acuId != 0){
            $arrayData = $this->dataId($item);

            $vari["acuId"] = $acuId;
            $vari["inputName"] = $arrayData["mod_acu_name"];
            $vari["inputLastname"] = $arrayData["mod_acu_fathers_lastname"]." ".$arrayData["mod_acu_mothers_lastname"];
            $vari["inputEmail"] = $email;
            $vari["entitieId"] = $entitieId;

            $cpeId = $this->createCustomersPersons($vari);
            if (!is_int($cpeId)) return 0;

            $vars["cpeId"] = $cpeId;
            $vars["inputUsername"] = $company;
            $vars["entitieId"] = $entitieId;
            $cenId = $this->createCustomersEnterprises($vars);
            if (!is_int($cenId)) return 0; 

            $rol = $this->addRoleToAccount(["acuId"=>$acuId, "rolId"=>1, "entitieId"=>$entitieId]); 
            if (!is_int($rol)) return 0;

            $newDb = _DATA_BASE_SUBFIX.$cenId;
            $this->fmt->querys->createDb($newDb);

            $querysDb = $this->fmt->querys->loadDbQuerys([
                "dbname" => $newDb,
                "path" => _DB_BASE_PATH."db_base.sql"
            ]);

            if ($querysDb["Error"] == 1){
                $rtn["Error"] = 1;
                $rtn["mensaje"] = "error, load query db_base.sql";
                return  $rtn;
            }
             

            $response["email"] = $email;
            $response["password"]  = base64_decode($arrayData["mod_acu_password"]);
            return $this->userValidate($response);
             
        } else {
            $rtn["Error"] = 1;
            $rtn["mensaje"] = "error, account not exist";
        }
        $this->fmt->querys->leave($rs);
        return $rtn;
    }

    public function addRoleToAccount(array $var = null)
    {
        //return $var;
        $acuId = $var["acuId"];
        $rolId = $var["rolId"];
        $entitieId = $var["entitieId"] ? $var["entitieId"] : 1;

        $insert = "mod_acu_user_rol_acu_id,
        mod_acu_user_rol_rol_id,
        mod_acu_user_rol_ent_id,
        mod_acu_user_rol_order";
        $values ="'" .$acuId . "','" . $rolId . "','" . $entitieId . "','0'";
        $sql= "insert into mod_accounts_users_roles (".$insert.") values (".$values.")";
        $this->fmt->querys->consult($sql,__METHOD__); 

        return 1;
    }
}