"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.add = exports.loadAccountsUsers = exports.accountsUsersIndex = void 0;

var _index = require("../../components/functions.js");

var _forms = require("../../components/forms.js");

var _modals = require("../../components/modals.js");

var _tables = require("../../components/tables.js");

var _renderTables = require("../../components/renders/renderTables.js");

var _renderModals = require("../../components/renders/renderModals.js");

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

/* renderColTitle,
	renderColState,
	renderColActionsBase, */
var pathurl = "modules/accounts/";
var _module = "accountsUsers";
var system = "accounts";
var tableId = "table-contents";

var accountsUsersIndex = function accountsUsersIndex() {
  console.log("accountsUsersIndex");
  (0, _index.loadView)(_PATH_WEB_NUCLEO + pathurl + "views/accountsUsers.html?" + _VS).then(function (htmlView) {
    //console.log(htmlView, module, system);
    loadAccountsUsers().then(function (response) {
      //console.log("loadAccountsUsers", response);
      (0, _index.stopLoadingBar)();
      $(".innerForm").remove();
      $(".bodyModule[module='" + _module + "']").html((0, _index.replaceEssentials)({
        str: htmlView,
        module: _module,
        system: system,
        pathurl: pathurl,
        name: (0, _index.dataModule)(_module, "name"),
        fn: "formNewContent",
        color: (0, _index.dataModule)(_module, "color")
      }));

      if (response.Error == 0 && response.items != 0) {
        var rows = "";

        for (var i in response.items) {
          var item = response.items[i]; //console.log("item", item);

          rows += (0, _renderTables.renderRowsTable)({
            id: item.id,
            content: (0, _renderTables.renderColCheck)({
              id: item.id
            }) + (0, _renderTables.renderColId)({
              id: item.id
            }) + (0, _renderTables.renderColTitle)({
              id: item.id,
              title: item.nameFull
            }) + (0, _renderTables.renderCol)({
              id: item.id,
              cls: '',
              attr: '',
              data: item.gender
            }) + (0, _renderTables.renderCol)({
              id: item.id,
              cls: '',
              attr: '',
              data: item.type
            }) + (0, _renderTables.renderCol)({
              id: item.id,
              cls: '',
              attr: '',
              data: item.timezone
            }) + (0, _renderTables.renderCol)({
              id: item.id,
              cls: '',
              attr: '',
              data: item.recordDate
            }) + (0, _renderTables.renderColState)({
              id: item.id,
              state: item.state,
              module: _module,
              system: system
            }) + (0, _renderTables.renderColActions)({
              id: item.id,
              name: item.title,
              type: "btnEdit,btnDelete",
              fnType: "formEditContent,deleteModuleItem",
              module: _module,
              system: system
            })
          });
        }

        (0, _tables.mountTable)({
          id: tableId,
          columns: [].concat(_toConsumableArray(_tables.colCheck), _toConsumableArray(_tables.colId), [{
            label: "Nombre Completo",
            cls: "colNameFull"
          }, {
            label: "Genero",
            cls: ""
          }, {
            label: "Tipo/r",
            cls: ""
          }, {
            label: "Timezone",
            cls: ""
          }, {
            label: "Fecha Registro",
            cls: "colDareRegister"
          }], _toConsumableArray(_tables.colState), _toConsumableArray(_tables.colActionsBase)),
          rows: rows,
          module: _module,
          system: system,
          container: ".bodyModule[module='" + _module + "'] .tbody"
        });
      } else if (response === 0 || response.items == 0) {
        $(".bodyModule[module='" + _module + "']  .tbody").html((0, _tables.renderEmpty)());
      } else {
        (0, _index.alertPage)({
          text: "Error. por favor contactarse con soporte. " + response.message,
          icon: "icn icon-alert-warning",
          animation_in: "bounceInRight",
          animation_out: "bounceOutRight",
          tipe: "danger",
          time: "3500",
          position: "top-left"
        });
      }
    })["catch"](console.warn());
  });
}; //asycs  


exports.accountsUsersIndex = accountsUsersIndex;

var loadAccountsUsers = function loadAccountsUsers(vars) {
  var url, data, res;
  return regeneratorRuntime.async(function loadAccountsUsers$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          //console.log('loadAccountsUsers', vars);
          url = _PATH_WEB_NUCLEO + "modules/accounts/controllers/apis/v1/accountsUsers.php";
          data = JSON.stringify({
            accessToken: (0, _index.accessToken)(),
            action: "loadAccountsUsers",
            vars: JSON.stringify(vars)
          });
          _context.prev = 2;
          _context.next = 5;
          return regeneratorRuntime.awrap(axios({
            async: true,
            method: "post",
            responseType: "json",
            url: url,
            headers: {},
            data: data
          }));

        case 5:
          res = _context.sent;
          return _context.abrupt("return", res.data);

        case 9:
          _context.prev = 9;
          _context.t0 = _context["catch"](2);
          console.log("Error: loadAccountsUsers");
          console.log(_context.t0);

        case 13:
        case "end":
          return _context.stop();
      }
    }
  }, null, null, [[2, 9]]);
};

exports.loadAccountsUsers = loadAccountsUsers;

var add = function add(vars) {
  var url, data, res;
  return regeneratorRuntime.async(function add$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          console.log('add', vars);
          url = _PATH_WEB_NUCLEO + "modules/accounts/controllers/apis/v1/accountsUsers.php";
          data = JSON.stringify({
            accessToken: (0, _index.accessToken)(),
            action: "add",
            vars: JSON.stringify(vars)
          });
          _context2.prev = 3;
          _context2.next = 6;
          return regeneratorRuntime.awrap(axios({
            async: true,
            method: "post",
            responseType: "json",
            url: url,
            headers: {},
            data: data
          }));

        case 6:
          res = _context2.sent;
          console.log(res.data);
          return _context2.abrupt("return", res.data);

        case 11:
          _context2.prev = 11;
          _context2.t0 = _context2["catch"](3);
          console.log("Error: add");
          console.log(_context2.t0);

        case 15:
        case "end":
          return _context2.stop();
      }
    }
  }, null, null, [[3, 11]]);
};

exports.add = add;